/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import java.util.Iterator;
import java.util.List;
import mods.betterfoliage.kotlin.Metadata;
import mods.betterfoliage.kotlin.collections.CollectionsKt;
import mods.betterfoliage.kotlin.jvm.JvmName;
import mods.betterfoliage.kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\u001a!\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u00020\u000b\"\u00020\u0002\u00a2\u0006\u0002\u0010\f\u001a&\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\t\u001a\u0015\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0004\" \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"brightnessComponents", "", "", "getBrightnessComponents", "()Ljava/util/List;", "setBrightnessComponents", "(Ljava/util/List;)V", "brSum", "multiplier", "", "brightness", "", "(Ljava/lang/Float;[I)I", "brWeighted", "br1", "weight1", "br2", "weight2", "brMul", "f", "colorMul", "BetterFoliage-compileKotlin"})
@JvmName(name="PixelFormat")
public final class PixelFormat {
    @NotNull
    private static List<Integer> brightnessComponents = CollectionsKt.listOf(20, 4);

    @NotNull
    public static final List<Integer> getBrightnessComponents() {
        return brightnessComponents;
    }

    public static final void setBrightnessComponents(@NotNull List<Integer> list) {
        Intrinsics.checkParameterIsNotNull(list, "<set-?>");
        brightnessComponents = list;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brMul(int $receiver, float f) {
        void result;
        void $receiver$iv;
        int weight = (int)(f * 256.0f);
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Iterable iterable = brightnessComponents;
        for (Object element$iv : $receiver$iv) {
            int shift = ((Number)element$iv).intValue();
            int raw = $receiver >> shift & 0xF;
            int weighted = raw * weight / 256;
            result.element |= weighted << shift;
        }
        return result.element;
    }

    public static final int colorMul(int $receiver, float f) {
        int weight = (int)(f * 256.0f);
        int red = ($receiver >> 16 & 0xFF) * weight / 256;
        int green = ($receiver >> 8 & 0xFF) * weight / 256;
        int blue = ($receiver & 0xFF) * weight / 256;
        return red << 16 | green << 8 | blue;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brSum(@Nullable Float multiplier, int ... brightness) {
        void result;
        void $receiver$iv;
        int idx;
        Intrinsics.checkParameterIsNotNull(brightness, "brightness");
        int size$iv = brightnessComponents.size();
        Integer[] result$iv = new Integer[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                Integer n3;
                void var7_16 = ++i$iv;
                void var19_14 = i$iv;
                Integer[] integerArray = result$iv;
                integerArray[var19_14] = n3 = Integer.valueOf(0);
            } while (i$iv != n2);
        }
        Integer[] sum = (Integer[])((Object[])result$iv);
        Object $receiver$iv2 = brightnessComponents;
        int index$iv22 = 0;
        Iterator i$iv = $receiver$iv2.iterator();
        while (i$iv.hasNext()) {
            void $receiver$iv3;
            Object item$iv = i$iv.next();
            int n4 = index$iv22++;
            int it = ((Number)item$iv).intValue();
            idx = n4;
            int[] $i$f$Array = brightness;
            for (int i = 0; i < ((void)$receiver$iv3).length; ++i) {
                void shift;
                void element$iv;
                void br = element$iv = $receiver$iv3[i];
                int comp = br >> shift & 0xF;
                int n5 = idx;
                sum[n5] = ((Number)sum[n5]).intValue() + comp;
            }
        }
        $receiver$iv2 = new Ref.IntRef();
        ((Ref.IntRef)$receiver$iv2).element = 0;
        Iterable index$iv22 = brightnessComponents;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void shift;
            int n6 = index$iv++;
            idx = ((Number)item$iv).intValue();
            int idx2 = n6;
            int comp = multiplier == null ? ((Number)sum[idx2]).intValue() << shift : (int)((float)((Number)sum[idx2]).intValue() * ((Number)multiplier).floatValue()) << shift;
            result.element |= comp;
        }
        return result.element;
    }

    /*
     * WARNING - void declaration
     */
    public static final int brWeighted(int br1, float weight1, int br2, float weight2) {
        void result;
        void $receiver$iv;
        int w1int = (int)(weight1 * 256.0f + 0.5f);
        int w2int = (int)(weight2 * 256.0f + 0.5f);
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Iterable iterable = brightnessComponents;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void shift;
            int n = index$iv++;
            int n2 = ((Number)item$iv).intValue();
            int idx = n;
            int comp1 = br1 >> shift & 0xF;
            int comp2 = br2 >> shift & 0xF;
            int compWeighted = (comp1 * w1int + comp2 * w2int) / 256;
            result.element |= (compWeighted & 0xF) << shift;
        }
        return result.element;
    }
}

