/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import mods.betterfoliage.kotlin.Metadata;
import mods.betterfoliage.kotlin.TypeCastException;
import mods.betterfoliage.kotlin.Unit;
import mods.betterfoliage.kotlin.collections.CollectionsKt;
import mods.betterfoliage.kotlin.io.ConstantsKt;
import mods.betterfoliage.kotlin.io.TextStreamsKt;
import mods.betterfoliage.kotlin.jvm.JvmName;
import mods.betterfoliage.kotlin.jvm.functions.Function0;
import mods.betterfoliage.kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.kotlin.sequences.Sequence;
import mods.betterfoliage.kotlin.text.Charsets;
import mods.betterfoliage.kotlin.text.StringsKt;
import mods.octarinecore.client.render.HSB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001d\u0010\u0012\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0086\u0002\u001a\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0086\u0002\u001a\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000fH\u0086\u0002\u001a\u0010\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b*\u00020\u0015\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0006*\u00020\u0015\u001a\u0015\u0010\u001d\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0011H\u0086\u0002\u001a%\u0010\u001f\u001a\u00020 *\u00020\u00062\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0086\u0002\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"resourceManager", "Lnet/minecraft/client/resources/SimpleReloadableResourceManager;", "getResourceManager", "()Lnet/minecraft/client/resources/SimpleReloadableResourceManager;", "asStream", "Ljava/io/InputStream;", "Ljava/awt/image/BufferedImage;", "getAsStream", "(Ljava/awt/image/BufferedImage;)Ljava/io/InputStream;", "averageColor", "", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getAverageColor", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Ljava/lang/Integer;", "textureLocation", "Lnet/minecraft/util/ResourceLocation;", "iconName", "", "get", "x", "y", "Lnet/minecraft/client/resources/IResource;", "Lnet/minecraft/client/resources/IResourceManager;", "domain", "path", "location", "getLines", "", "loadImage", "plus", "str", "set", "", "value", "BetterFoliage-compileKotlin"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    public static final SimpleReloadableResourceManager getResourceManager() {
        IResourceManager iResourceManager = Minecraft.func_71410_x().func_110442_L();
        if (iResourceManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.client.resources.SimpleReloadableResourceManager");
        }
        return (SimpleReloadableResourceManager)iResourceManager;
    }

    @NotNull
    public static final ResourceLocation plus(ResourceLocation $receiver, @NotNull String str) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(str, "str");
        return new ResourceLocation($receiver.func_110624_b(), $receiver.func_110623_a() + str);
    }

    @Nullable
    public static final IResource get(IResourceManager $receiver, @NotNull String domain, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(domain, "domain");
        Intrinsics.checkParameterIsNotNull(path, "path");
        return Utils.get($receiver, new ResourceLocation(domain, path));
    }

    @Nullable
    public static final IResource get(IResourceManager $receiver, @NotNull ResourceLocation location) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(location, "location");
        return mods.octarinecore.Utils.tryDefault(null, (Function0)new Function0<IResource>($receiver, location){
            final /* synthetic */ IResourceManager receiver$0;
            final /* synthetic */ ResourceLocation $location;

            public final IResource invoke() {
                return this.receiver$0.func_110536_a(this.$location);
            }
            {
                this.receiver$0 = iResourceManager;
                this.$location = resourceLocation;
                super(0);
            }
        });
    }

    @Nullable
    public static final BufferedImage loadImage(IResource $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return mods.octarinecore.Utils.tryDefault(null, (Function0)new Function0<BufferedImage>($receiver){
            final /* synthetic */ IResource receiver$0;

            public final BufferedImage invoke() {
                return ImageIO.read(this.receiver$0.func_110527_b());
            }
            {
                this.receiver$0 = iResource;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getLines(IResource $receiver) {
        Reader $receiver$iv$iv22;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList<String> result = CollectionsKt.arrayListOf(new String[0]);
        InputStream inputStream = $receiver.func_110527_b();
        Object object = null;
        boolean bl = true;
        Object var5_7 = null;
        if (var5_7 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
        }
        if (bl & true) {
            object = Charsets.UTF_8;
        }
        InputStream inputStream2 = inputStream;
        $receiver$iv$iv22 = new InputStreamReader((InputStream)((Object)$receiver$iv$iv22), (Charset)object);
        int $i$f$reader = 0;
        boolean bl2 = true;
        Object var7_15 = null;
        if (var7_15 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl2 & true) {
            $i$f$reader = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        Reader $receiver$iv = $receiver$iv$iv22 instanceof BufferedReader ? (BufferedReader)$receiver$iv$iv22 : new BufferedReader($receiver$iv$iv22, $i$f$reader);
        object = $receiver$iv;
        int $receiver$iv$iv22 = 0;
        $i$f$reader = 1;
        Object $i$f$buffered = null;
        if ($i$f$buffered != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (($i$f$reader & 1) != 0) {
            $receiver$iv$iv22 = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        Closeable $receiver$iv$iv = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, $receiver$iv$iv22);
        boolean closed$iv$iv = false;
        try {
            void $receiver$iv2;
            Sequence<String> it;
            Object it$iv = (BufferedReader)$receiver$iv$iv;
            Sequence<String> $i$f$bufferedReader = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            for (Object element$iv : $receiver$iv2) {
                String it2 = (String)element$iv;
                result.add(it2);
            }
            it$iv = Unit.INSTANCE;
        }
        catch (Exception e$iv$iv) {
            closed$iv$iv = true;
            try {
                $receiver$iv$iv.close();
            }
            catch (Exception closeException$iv$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv$iv;
        }
        finally {
            if (!closed$iv$iv) {
                $receiver$iv$iv.close();
            }
        }
        return result;
    }

    public static final int get(BufferedImage $receiver, int x, int y) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getRGB(x, y);
    }

    public static final void set(BufferedImage $receiver, int x, int y, int value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.setRGB(x, y, value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InputStream getAsStream(BufferedImage $receiver) {
        void $receiver$iv;
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        ByteArrayOutputStream it = (ByteArrayOutputStream)$receiver$iv;
        ImageIO.write((RenderedImage)$receiver, "PNG", it);
        byte[] byArray = it.toByteArray();
        byteArrayInputStream2(byArray);
        return byteArrayInputStream3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer getAverageColor(TextureAtlasSprite $receiver) {
        void $receiver$iv;
        void args$iv;
        ResourceLocation resourceLocation;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ResourceLocation locationNoDirs = new ResourceLocation($receiver.func_94215_i());
        String string = "textures/blocks/%s.png";
        Object[] objectArray = new Object[]{locationNoDirs.func_110623_a()};
        String string2 = locationNoDirs.func_110624_b();
        ResourceLocation resourceLocation2 = resourceLocation;
        ResourceLocation resourceLocation3 = resourceLocation;
        void v1 = args$iv;
        String string3 = String.format((String)$receiver$iv, Arrays.copyOf(v1, ((void)v1).length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        resourceLocation2(string2, string4);
        ResourceLocation locationWithDirs = resourceLocation3;
        Object object = Utils.get((IResourceManager)Utils.getResourceManager(), locationWithDirs);
        if (object == null || (object = Utils.loadImage((IResource)object)) == null) {
            return null;
        }
        Object image = object;
        int numOpaque = 0;
        double sumHueX = 0.0;
        double sumHueY = 0.0;
        float sumSaturation = 0.0f;
        float sumBrightness = 0.0f;
        int n = 0;
        int n2 = ((BufferedImage)image).getWidth() - 1;
        if (n <= n2) {
            while (true) {
                void x;
                int n3;
                int n4;
                if ((n4 = 0) <= (n3 = ((BufferedImage)image).getHeight() - 1)) {
                    while (true) {
                        void y;
                        int pixel = Utils.get((BufferedImage)image, (int)x, (int)y);
                        int alpha = pixel >> 24 & 0xFF;
                        HSB hsb = HSB.Companion.fromColor(pixel);
                        if (alpha == 255) {
                            ++numOpaque;
                            sumHueX += Math.cos(((double)hsb.getHue() - 0.5) * mods.octarinecore.Utils.PI2);
                            sumHueY += Math.sin(((double)hsb.getHue() - 0.5) * mods.octarinecore.Utils.PI2);
                            sumSaturation += hsb.getSaturation();
                            sumBrightness += hsb.getBrightness();
                        }
                        if (y == n3) break;
                        ++y;
                    }
                }
                if (x == n2) break;
                ++x;
            }
        }
        float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / mods.octarinecore.Utils.PI2 + 0.5);
        return new HSB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque).getAsColor();
    }

    @NotNull
    public static final ResourceLocation textureLocation(@NotNull String iconName) {
        Intrinsics.checkParameterIsNotNull(iconName, "iconName");
        ResourceLocation $receiver$iv = new ResourceLocation(iconName);
        ResourceLocation it = $receiver$iv;
        return StringsKt.startsWith$default(it.func_110623_a(), "mcpatcher", false, 2, null) ? it : new ResourceLocation(it.func_110624_b(), "textures/blocks/" + it.func_110623_a());
    }
}

