/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.BlockFuelStation;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.proxy.CommonProxy;
import de.maxhenkel.car.registries.FuelStationFluid;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopTileentity;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFuelStation
extends TileEntityBase
implements ITickable,
IFluidHandler,
SoundLoopTileentity.ISoundLoopable,
IInventory {
    private FluidStack storage;
    public int maxStorageAmount = 16000;
    private final int transferRate = Config.fuelStationTransferRate;
    private int fuelCounter = 0;
    private boolean isFueling;
    private boolean wasFueling;

    public void func_73660_a() {
        EntityCarFuelBase car = this.getCarInFront();
        if (car == null) {
            if (this.fuelCounter > 0 || this.isFueling) {
                this.fuelCounter = 0;
                this.isFueling = false;
                this.synchronize();
                this.func_70296_d();
            }
            return;
        }
        if (!this.isFueling) {
            return;
        }
        if (this.storage == null) {
            return;
        }
        FluidStack result = FluidUtil.tryFluidTransfer((IFluidHandler)car, (IFluidHandler)this, (int)this.transferRate, (boolean)true);
        if (result != null) {
            this.fuelCounter += result.amount;
            this.synchronize(100);
            this.func_70296_d();
            if (!this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = true;
        } else {
            if (this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = false;
        }
    }

    public boolean isValidFluid(Fluid f) {
        for (FuelStationFluid recipe : FuelStationFluid.REGISTRY) {
            if (!recipe.getInput().isValid(f)) continue;
            return true;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.fuelCounter;
            }
            case 1: {
                if (this.storage != null) {
                    return this.storage.amount;
                }
                return 0;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.fuelCounter = value;
                break;
            }
            case 1: {
                if (this.storage == null) break;
                this.storage.amount = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("counter", this.fuelCounter);
        if (this.storage != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.storage.writeToNBT(comp);
            compound.func_74782_a("fluid", (NBTBase)comp);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.fuelCounter = compound.func_74762_e("counter");
        if (compound.func_74764_b("fluid")) {
            NBTTagCompound comp = compound.func_74775_l("fluid");
            this.storage = FluidStack.loadFluidStackFromNBT((NBTTagCompound)comp);
        }
        super.func_145839_a(compound);
    }

    public boolean isFueling() {
        return this.isFueling;
    }

    public int getFuelCounter() {
        return this.fuelCounter;
    }

    public void setStorage(FluidStack storage) {
        this.storage = storage;
        this.func_70296_d();
        this.synchronize();
    }

    public FluidStack getStorage() {
        return this.storage;
    }

    public void setFuelCounter(int fuelCounter) {
        this.fuelCounter = fuelCounter;
        this.func_70296_d();
        this.synchronize();
    }

    public void setFueling(boolean isFueling) {
        if (this.getCarInFront() == null) {
            return;
        }
        if (isFueling && !this.isFueling && this.field_145850_b.field_72995_K) {
            this.playSound();
        }
        this.isFueling = isFueling;
        this.synchronize();
    }

    public String getRenderText() {
        EntityCarFuelBase car = this.getCarInFront();
        if (car == null) {
            return new TextComponentTranslation("fuelstation.no_car", new Object[0]).func_150254_d();
        }
        if (this.fuelCounter <= 0) {
            return new TextComponentTranslation("fuelstation.ready", new Object[0]).func_150254_d();
        }
        return new TextComponentTranslation("fuelstation.fuel_amount", new Object[]{this.fuelCounter}).func_150254_d();
    }

    public EntityCarFuelBase getCarInFront() {
        IBlockState ownState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!ownState.func_177230_c().equals((Object)ModBlocks.FUEL_STATION)) {
            return null;
        }
        EnumFacing facing = (EnumFacing)ownState.func_177229_b((IProperty)BlockFuelStation.FACING);
        BlockPos start = this.func_174877_v().func_177972_a(facing);
        AxisAlignedBB aabb = new AxisAlignedBB((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p(), (double)(start.func_177958_n() + 1), (double)(start.func_177956_o() + 1), (double)(start.func_177952_p() + 1));
        List cars = this.field_145850_b.func_72872_a(EntityCarFuelBase.class, aabb);
        if (cars.isEmpty()) {
            return null;
        }
        return (EntityCarFuelBase)((Object)cars.get(0));
    }

    public boolean canCarBeFueled() {
        EntityCarFuelBase car = this.getCarInFront();
        if (car == null) {
            return false;
        }
        FluidStack result = FluidUtil.tryFluidTransfer((IFluidHandler)car, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        return result != null && result.amount > 0;
    }

    public IBlockState getBlockState() {
        IBlockState ownState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!ownState.func_177230_c().equals((Object)ModBlocks.FUEL_STATION)) {
            return null;
        }
        return ownState;
    }

    public EnumFacing getDirection() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return EnumFacing.NORTH;
        }
        return (EnumFacing)state.func_177229_b((IProperty)BlockFuelStation.FACING);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                return TileEntityFuelStation.this.storage;
            }

            public int getCapacity() {
                return TileEntityFuelStation.this.maxStorageAmount;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return TileEntityFuelStation.this.isValidFluid(fluidStack.getFluid());
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return true;
            }

            public boolean canDrain() {
                return true;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.isValidFluid(resource.getFluid())) {
            return 0;
        }
        if (this.storage == null) {
            int amount = Math.min(resource.amount, this.maxStorageAmount);
            if (doFill) {
                this.storage = new FluidStack(resource.getFluid(), amount);
                this.synchronize();
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.storage.getFluid())) {
            int amount = Math.min(resource.amount, this.maxStorageAmount - this.storage.amount);
            if (doFill) {
                this.storage.amount += amount;
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.storage == null) {
            return null;
        }
        if (this.storage.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.amount, this.storage.amount);
            Fluid f = this.storage.getFluid();
            if (doDrain) {
                this.storage.amount -= amount;
                if (this.storage.amount <= 0) {
                    this.storage = null;
                    this.synchronize();
                }
                this.func_70296_d();
            }
            return new FluidStack(f, amount);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.storage == null) {
            return null;
        }
        int amount = Math.min(maxDrain, this.storage.amount);
        Fluid f = this.storage.getFluid();
        if (doDrain) {
            this.storage.amount -= amount;
            if (this.storage.amount <= 0) {
                this.storage = null;
                this.synchronize();
            }
            this.func_70296_d();
        }
        return new FluidStack(f, amount);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void sendStartFuelPacket(boolean start) {
        if (this.field_145850_b.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageStartFuel(this.field_174879_c, start));
        }
    }

    @Override
    public boolean shouldSoundBePlayed() {
        if (!this.isFueling) {
            return false;
        }
        return this.canCarBeFueled();
    }

    @SideOnly(value=Side.CLIENT)
    public void playSound() {
        ModSounds.playSoundLoop(new SoundLoopTileentity(ModSounds.gas_ststion, SoundCategory.BLOCKS, this), this.field_145850_b);
    }

    @Override
    public void play() {
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public void func_174888_l() {
    }
}

