/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityTank
extends TileEntityBase
implements IFluidHandler,
ITickable {
    private FluidStack fluid = null;
    public static final int CAPACITY = 16000;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.synchronize();
        }
        if (this.fluid == null) {
            return;
        }
        this.checkDown();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (this.fluid == null) {
                return;
            }
            this.checkSide(facing);
        }
    }

    public void checkSide(EnumFacing side) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack other = otherTank.getFluid();
        if (other == null) {
            otherTank.setFluid(new FluidStack(this.fluid.getFluid(), 0));
            other = otherTank.getFluid();
        }
        if (!other.getFluid().equals(this.fluid.getFluid())) {
            return;
        }
        int dif = other.amount - this.fluid.amount;
        if (dif >= -2) {
            return;
        }
        FluidUtil.tryFluidTransfer((IFluidHandler)otherTank, (IFluidHandler)this, (int)(-dif / 2), (boolean)true);
    }

    public void checkDown() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack stack = FluidUtil.tryFluidTransfer((IFluidHandler)otherTank, (IFluidHandler)this, (int)Integer.MAX_VALUE, (boolean)true);
        if (stack == null) {
            return;
        }
        if (this.fluid != null && this.fluid.amount <= 0) {
            this.fluid = null;
        }
    }

    public float getFillPercent() {
        if (this.fluid == null) {
            return 0.0f;
        }
        return (float)this.fluid.amount / 16000.0f;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.fluid != null && this.fluid.amount > 0) {
            NBTTagCompound comp = new NBTTagCompound();
            this.fluid.writeToNBT(comp);
            compound.func_74782_a("fluid", (NBTBase)comp);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("fluid")) {
            NBTTagCompound comp = compound.func_74775_l("fluid");
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)comp);
        } else {
            this.fluid = null;
        }
        super.func_145839_a(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                return TileEntityTank.this.fluid;
            }

            public int getCapacity() {
                return 16000;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return true;
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return true;
            }

            public boolean canDrain() {
                return true;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.fluid == null) {
            int amount = Math.min(resource.amount, 16000);
            if (doFill) {
                this.fluid = new FluidStack(resource.getFluid(), amount);
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.fluid.getFluid())) {
            int amount = Math.min(resource.amount, 16000 - this.fluid.amount);
            if (doFill) {
                this.fluid.amount += amount;
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        if (this.fluid.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.amount, this.fluid.amount);
            Fluid f = this.fluid.getFluid();
            if (doDrain) {
                this.fluid.amount -= amount;
                if (this.fluid.amount <= 0) {
                    this.fluid = null;
                }
                this.func_70296_d();
            }
            return new FluidStack(f, amount);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        int amount = Math.min(maxDrain, this.fluid.amount);
        Fluid f = this.fluid.getFluid();
        if (doDrain) {
            this.fluid.amount -= amount;
            if (this.fluid.amount <= 0) {
                this.fluid = null;
            }
            this.func_70296_d();
        }
        return new FluidStack(f, amount);
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }
}

