/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public abstract class EntityCarDamageBase
extends EntityCarBase {
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityCarDamageBase.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityCarDamageBase(World worldIn) {
        super(worldIn);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_180799_ab()) {
            this.addDamage(1.0f);
        }
        if (this.isStarted() || this.getDamage() > 99.0f) {
            this.particles();
        }
    }

    public void particles() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getDamage() < 50.0f) {
            return;
        }
        int amount = 0;
        int damage = (int)this.getDamage();
        if (damage < 70) {
            if (this.field_70146_Z.nextInt(10) != 0) {
                return;
            }
            amount = 1;
        } else if (damage < 80) {
            if (this.field_70146_Z.nextInt(5) != 0) {
                return;
            }
            amount = 1;
        } else {
            amount = damage < 90 ? 2 : 3;
        }
        for (int i = 0; i < amount; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void onCollision(float speed) {
        super.onCollision(speed);
        float percSpeed = speed / this.getMaxSpeed();
        if (percSpeed > 0.8f) {
            this.addDamage(percSpeed * 5.0f);
            this.playCrashSound();
            if (percSpeed > 0.9f) {
                this.setStarted(false);
                this.playStopSound();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)source.func_76346_g();
        if (player == null) {
            return false;
        }
        if (player.equals((Object)this.getDriver())) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (player.func_70093_af()) {
                this.destroyCar(player, false);
                return true;
            }
            return false;
        }
        if (this.getDamage() >= 90.0f && amount > 2.0f) {
            this.destroyCar(player, true);
        }
        return false;
    }

    public void addDamage(float val) {
        this.setDamage(this.getDamage() + val);
    }

    @Override
    public boolean canStartCarEngine(EntityPlayer player) {
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        if (this.getDamage() >= 95.0f) {
            boolean b = this.field_70146_Z.nextInt(5) == 0;
            return b;
        }
        if (this.getDamage() >= 90.0f) {
            boolean b = this.field_70146_Z.nextBoolean();
            return b;
        }
        if (this.getDamage() >= 80.0f) {
            boolean b = this.field_70146_Z.nextInt(5) != 0;
            return b;
        }
        if (this.getDamage() >= 50.0f) {
            boolean b = this.field_70146_Z.nextInt(15) != 0;
            return b;
        }
        return super.canStartCarEngine(player);
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.func_70090_H()) {
            this.addDamage(25.0f);
            return false;
        }
        if (this.func_180799_ab()) {
            return false;
        }
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float damage) {
        if (damage > 100.0f) {
            damage = 100.0f;
        } else if (damage < 0.0f) {
            damage = 0.0f;
        }
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("damage", this.getDamage());
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDamage(compound.func_74760_g("damage"));
    }
}

