/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.registries.CarFluid;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class EntityCarFuelBase
extends EntityCarDamageBase
implements IFluidHandler {
    private static final DataParameter<Integer> FUEL_AMOUNT = EntityDataManager.func_187226_a(EntityCarFuelBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> FUEL_TYPE = EntityDataManager.func_187226_a(EntityCarFuelBase.class, (DataSerializer)DataSerializers.field_187194_d);
    protected int maxFuel = 1000;

    public EntityCarFuelBase(World worldIn) {
        super(worldIn);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.fuelTick();
    }

    protected int calculateTickFuel() {
        double efficiency = this.getEfficiency(this.getFluid());
        int ticks = (int)(efficiency * 100.0);
        if (ticks <= 0) {
            ticks = 1;
        }
        return ticks;
    }

    protected void fuelTick() {
        float fuel = this.getFuelAmount();
        int tickFuel = this.calculateTickFuel();
        if (fuel > 0.0f && this.isAccelerating()) {
            if (this.field_70173_aa % tickFuel == 0) {
                this.acceleratingFuelTick();
            }
        } else if (fuel > 0.0f && this.isStarted() && this.field_70173_aa % (tickFuel * 100) == 0) {
            this.idleFuelTick();
        }
    }

    protected void idleFuelTick() {
        this.removeFuel(1);
    }

    protected void acceleratingFuelTick() {
        this.removeFuel(1);
    }

    private void removeFuel(int amount) {
        int fuel = this.getFuelAmount();
        int newFuel = fuel - amount;
        if (newFuel <= 0) {
            this.setFuelAmount(0);
        } else {
            this.setFuelAmount(newFuel);
        }
    }

    @Override
    public boolean canPlayerDriveCar(EntityPlayer player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canPlayerDriveCar(player);
    }

    @Override
    public boolean canStartCarEngine(EntityPlayer player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canStartCarEngine(player);
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUEL_AMOUNT, (Object)0);
        this.field_70180_af.func_187214_a(FUEL_TYPE, (Object)new String());
    }

    public void setFuelAmount(int fuel) {
        this.field_70180_af.func_187227_b(FUEL_AMOUNT, (Object)fuel);
    }

    public void setFuelType(String fluid) {
        this.field_70180_af.func_187227_b(FUEL_TYPE, (Object)fluid);
    }

    public void setFuelType(Fluid fluid) {
        this.field_70180_af.func_187227_b(FUEL_TYPE, (Object)fluid.getName());
    }

    public String getFuelType() {
        return (String)this.field_70180_af.func_187225_a(FUEL_TYPE);
    }

    @Nullable
    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.getFuelType());
    }

    public int getFuelAmount() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL_AMOUNT);
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public boolean isValidFuel(Fluid fluid) {
        return this.getEfficiency(fluid) > 0.0;
    }

    public double getEfficiency(Fluid fluid) {
        if (fluid == null) {
            return 1.0;
        }
        for (CarFluid cf : CarFluid.REGISTRY) {
            if (!cf.getInput().isValid(fluid)) continue;
            return cf.getEfficiency();
        }
        return 0.0;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("fuel", this.getFuelAmount());
        compound.func_74778_a("fuel_type", this.getFuelType());
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFuelAmount(compound.func_74762_e("fuel"));
        if (compound.func_74764_b("fuel_type")) {
            this.setFuelType(compound.func_74779_i("fuel_type"));
        } else {
            this.setFuelType(ModFluids.BIO_DIESEL.getName());
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                Fluid f = EntityCarFuelBase.this.getFluid();
                if (f == null) {
                    return new FluidStack((Fluid)ModFluids.BIO_DIESEL, EntityCarFuelBase.this.getFuelAmount());
                }
                return new FluidStack(f, EntityCarFuelBase.this.getFuelAmount());
            }

            public int getCapacity() {
                return EntityCarFuelBase.this.maxFuel;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return EntityCarFuelBase.this.isValidFuel(fluidStack.getFluid());
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrain() {
                return false;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.isValidFuel(resource.getFluid())) {
            return 0;
        }
        if (this.getFluid() != null && this.getFuelAmount() > 0 && !resource.getFluid().equals(this.getFluid())) {
            return 0;
        }
        int amount = Math.min(resource.amount, this.maxFuel - this.getFuelAmount());
        if (doFill) {
            int i = this.getFuelAmount() + amount;
            if (i > this.maxFuel) {
                i = this.maxFuel;
            }
            this.setFuelAmount(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }
}

