/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.tools.ItemTools;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class EntityCarLockBase
extends EntityCarInventoryBase {
    private static final DataParameter<Boolean> LOCKED = EntityDataManager.func_187226_a(EntityCarInventoryBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityCarLockBase(World worldIn) {
        super(worldIn);
    }

    @Override
    public boolean canPlayerEnterCar(EntityPlayer player) {
        if (this.isLocked()) {
            return false;
        }
        return super.canPlayerEnterCar(player);
    }

    @Override
    public void destroyCar(EntityPlayer player, boolean dropParts) {
        if (this.isLocked()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.car_locked", new Object[0]));
            return;
        }
        super.destroyCar(player, dropParts);
    }

    @Override
    public boolean canPlayerAccessInventoryExternal(EntityPlayer player) {
        if (this.isLocked()) {
            return false;
        }
        return super.canPlayerAccessInventoryExternal(player);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOCKED, (Object)false);
    }

    public void setLocked(boolean locked, boolean playsound) {
        if (locked && playsound) {
            this.playLockSound();
        } else if (!locked && playsound) {
            this.playUnLockSound();
        }
        this.field_70180_af.func_187227_b(LOCKED, (Object)locked);
    }

    public boolean isLocked() {
        return (Boolean)this.field_70180_af.func_187225_a(LOCKED);
    }

    public void playLockSound() {
        ModSounds.playSound(this.getLockSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playUnLockSound() {
        ModSounds.playSound(this.getUnLockSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public SoundEvent getLockSound() {
        return ModSounds.car_lock;
    }

    public SoundEvent getUnLockSound() {
        return ModSounds.car_unlock;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("locked", this.isLocked());
        super.func_70014_b(compound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        this.setLocked(compound.func_74767_n("locked"), false);
        super.func_70037_a(compound);
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
        UUID uuid;
        if (player.func_70093_af() && player.field_71075_bZ.field_75098_d && !ItemTools.isStackEmpty(stack) && stack.func_77973_b().equals((Object)ModItems.KEY) && (uuid = ItemKey.getCar(stack)) == null) {
            ItemKey.setCar(stack, this.func_110124_au());
            return true;
        }
        return super.func_184230_a(player, stack, hand);
    }
}

