/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicleBase
extends Entity {
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;

    public EntityVehicleBase(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.field_70138_W = 0.6f;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
        }
        this.func_184189_br();
        super.func_70071_h_();
        this.tickLerp();
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (passenger instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)passenger;
            EnumFacing facing = this.func_174811_aO();
            double offsetX = 0.0;
            double offsetZ = 0.0;
            AxisAlignedBB playerbb = player.func_174813_aQ();
            double playerHitboxWidth = (playerbb.field_72336_d - playerbb.field_72340_a) / 2.0;
            double carHitboxWidth = this.field_70130_N / 2.0f;
            double offset = playerHitboxWidth + carHitboxWidth + 0.2;
            player.func_70634_a(this.field_70165_t + (offsetX += (double)facing.func_82601_c() * offset), this.field_70163_u, this.field_70161_v + (offsetZ += (double)facing.func_82599_e() * offset));
        }
    }

    public EntityPlayer getDriver() {
        List passengers = this.func_184188_bt();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof EntityPlayer) {
            return (EntityPlayer)passengers.get(0);
        }
        return null;
    }

    public int getPassengerSize() {
        return 1;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public float getFrontOffsetForPassenger(int i, Entity passenger) {
        return 0.0f;
    }

    public float getsideOffsetForPassenger(int i, Entity passenger) {
        return 0.0f;
    }

    public void func_184232_k(Entity passenger) {
        if (!this.func_184196_w(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        List passengers = this.func_184188_bt();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            front = this.getFrontOffsetForPassenger(i, passenger);
            side = this.getsideOffsetForPassenger(i, passenger);
        }
        Vec3d vec3d = new Vec3d(front, 0.0, side).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
        passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + this.func_70042_X(), this.field_70161_v + vec3d.field_72449_c);
        passenger.field_70177_z += this.deltaRotation;
        passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public Entity func_184179_bs() {
        return this.getDriver();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    private void tickLerp() {
        if (this.steps > 0 && !this.func_184186_bw()) {
            double x = this.field_70165_t + (this.clientX - this.field_70165_t) / (double)this.steps;
            double y = this.field_70163_u + (this.clientY - this.field_70163_u) / (double)this.steps;
            double z = this.field_70161_v + (this.clientZ - this.field_70161_v) / (double)this.steps;
            double d3 = MathHelper.func_76138_g((double)(this.clientYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.steps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.clientPitch - (double)this.field_70125_A) / (double)this.steps);
            --this.steps;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static final double calculateMotionX(float speed, float rotationYaw) {
        return MathHelper.func_76126_a((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static final double calculateMotionZ(float speed, float rotationYaw) {
        return MathHelper.func_76134_b((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (!player.func_70093_af()) {
            if (player.func_184187_bx() != this && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean doesEnterThirdPerson() {
        return true;
    }

    public abstract String getID();
}

