/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.tools.ItemTools;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerBase
extends Container {
    protected IInventory tileInventory;
    protected IInventory playerInventory;
    private int[] fields = new int[0];

    public ContainerBase(IInventory tileInventory, IInventory playerInventory) {
        this.tileInventory = tileInventory;
        this.playerInventory = playerInventory;
    }

    protected void addInvSlots() {
        if (this.playerInventory != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new Slot(this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + this.getInvOffset()));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot(this.playerInventory, k, 8 + k * 18, 142 + this.getInvOffset()));
            }
        }
    }

    public int getInvOffset() {
        return 0;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Nullable
    public IInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemTools.EMPTY;
        }
        ItemStack stack = ItemTools.EMPTY;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemTools.EMPTY;
            }
            slot.func_75220_a(stackInSlot, stack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(ItemTools.EMPTY);
            } else {
                slot.func_75215_d(stackInSlot);
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return ItemTools.EMPTY;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean supportsShiftClick(int slotIndex) {
        return true;
    }

    protected boolean supportsShiftClick(EntityPlayer player, int slotIndex) {
        return this.supportsShiftClick(slotIndex);
    }

    protected boolean performMerge(EntityPlayer player, int slotIndex, ItemStack stack) {
        return this.performMerge(slotIndex, stack);
    }

    protected boolean performMerge(int slotIndex, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.field_75151_b.size();
        if (slotIndex < invBase) {
            return this.func_75135_a(stack, invBase, invFull, true);
        }
        return this.func_75135_a(stack, 0, invBase, false);
    }

    protected int getSizeInventory() {
        if (this.tileInventory == null) {
            return 0;
        }
        return this.tileInventory.func_70302_i_();
    }

    public void func_75142_b() {
        super.func_75142_b();
        int fieldCount = this.tileInventory.func_174890_g();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.field_75149_d.get(i);
            for (int field = 0; field < fieldCount; ++field) {
                if (field >= this.fields.length || this.fields[field] == this.tileInventory.func_174887_a_(field)) continue;
                icontainerlistener.func_71112_a((Container)this, field, this.tileInventory.func_174887_a_(field));
            }
        }
        this.fields = new int[fieldCount];
        for (int field = 0; field < fieldCount; ++field) {
            this.fields[field] = this.tileInventory.func_174887_a_(field);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        for (int field = 0; field < this.fields.length; ++field) {
            listener.func_71112_a((Container)this, field, this.fields[field]);
        }
    }

    public void func_75137_b(int id, int data) {
        this.tileInventory.func_174885_b(id, data);
    }

    public int getField(int i) {
        if (i >= this.fields.length) {
            return 0;
        }
        return this.fields[i];
    }
}

