/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.net.MessageOpenGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.car.proxy.CommonProxy;
import de.maxhenkel.tools.MathTools;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCarWorkshopRepair
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car_workshop_repair.png");
    private static final int fontColor = 0x404040;
    private EntityPlayer player;
    private TileEntityCarWorkshop tile;
    private float rotoation;
    private GuiButton buttonBack;
    private GuiButton buttonRepair;

    public GuiCarWorkshopRepair(ContainerCarWorkshopRepair container) {
        super((Container)container);
        this.player = container.getPlayer();
        this.tile = container.getTile();
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonRepair = this.func_189646_b(new GuiButton(0, this.field_147003_i + this.field_146999_f - 7 - 60, this.field_147009_r + 105, 60, 20, new TextComponentTranslation("button.repair_car", new Object[0]).func_150254_d()));
        this.buttonRepair.field_146124_l = false;
        this.buttonBack = this.func_189646_b(new GuiButton(1, this.field_147003_i + 7, this.field_147009_r + 105, 60, 20, new TextComponentTranslation("button.back", new Object[0]).func_150254_d()));
        this.buttonBack.field_146124_l = true;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.tile.func_145748_c_().func_150260_c(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.player.field_71071_by.func_145748_c_().func_150254_d(), 8, this.field_147000_g - 96 + 2, 0x404040);
        EntityCarBase carTop = this.tile.getCarOnTop();
        if (!(carTop instanceof EntityCarDamageBase)) {
            this.buttonRepair.field_146124_l = false;
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carTop;
        if (mouseX >= this.field_147003_i + 52 && mouseX <= this.field_147003_i + 123 && mouseY >= this.field_147009_r + 81 && mouseY <= this.field_147009_r + 90) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(new TextComponentTranslation("tooltip.damage", new Object[]{MathTools.round(car.getDamage(), 2)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.buttonRepair.field_146124_l = this.tile.areRepairItemsInside() && car.getDamage() > 0.0f;
        this.drawCar(carTop);
    }

    private void drawCar(EntityCarBase car) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MathTools.drawCarOnScreen(this.field_146999_f / 2, 55, 23, this.rotoation, car);
        float parts = Minecraft.func_71410_x().func_184121_ak();
        this.rotoation += parts / 4.0f;
        if (!(this.rotoation < 360.0f)) {
            this.rotoation = 0.0f;
        }
    }

    public double getDamagePercent(EntityCarDamageBase car) {
        float dmg = car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathTools.round(dmg, 2);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawDamage();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawDamage() {
        EntityCarBase car = this.tile.getCarOnTop();
        if (!(car instanceof EntityCarDamageBase)) {
            return;
        }
        EntityCarDamageBase c = (EntityCarDamageBase)car;
        double percent = 100.0 - this.getDamagePercent(c);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int scaled = (int)(72.0 * percent / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + 52, j + 81, 176, 0, scaled, 10);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.buttonBack.field_146127_k) {
            if (this.tile.func_145831_w().field_72995_K) {
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageOpenGui(this.tile.func_174877_v(), 9, this.player).open(this.player));
            }
        } else if (button.field_146127_k == this.buttonRepair.field_146127_k && this.tile.func_145831_w().field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageRepairCar(this.tile.func_174877_v(), this.player));
        }
    }
}

