/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.reciepe;

import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.reciepe.CarBuilderSport;
import de.maxhenkel.car.reciepe.CarBuilderTransporter;
import de.maxhenkel.car.reciepe.CarBuilderWoodCar;
import de.maxhenkel.car.reciepe.CarBuilderWoodCarBig;
import de.maxhenkel.car.reciepe.ICarCraftingInventory;
import de.maxhenkel.car.reciepe.ICarRecipe;
import de.maxhenkel.car.reciepe.ICarbuilder;
import de.maxhenkel.car.reciepe.ShapedCarRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CarCraftingManager {
    private static final CarCraftingManager INSTANCE = new CarCraftingManager();
    private final List<ICarRecipe> recipes = new ArrayList<ICarRecipe>();

    public static CarCraftingManager getInstance() {
        return INSTANCE;
    }

    private CarCraftingManager() {
        this.addRecipe(new CarBuilderWoodCar(BlockPlanks.EnumType.OAK), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 0));
        this.addRecipe(new CarBuilderWoodCar(BlockPlanks.EnumType.SPRUCE), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 1));
        this.addRecipe(new CarBuilderWoodCar(BlockPlanks.EnumType.BIRCH), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 2));
        this.addRecipe(new CarBuilderWoodCar(BlockPlanks.EnumType.JUNGLE), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 3));
        this.addRecipe(new CarBuilderWoodCar(BlockPlanks.EnumType.ACACIA), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 4));
        this.addRecipe(new CarBuilderWoodCar(BlockPlanks.EnumType.DARK_OAK), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 5));
        this.addRecipe(new CarBuilderWoodCarBig(BlockPlanks.EnumType.OAK), "WSSUC", "EPPPP", "TPFPT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 0));
        this.addRecipe(new CarBuilderWoodCarBig(BlockPlanks.EnumType.SPRUCE), "WSSUC", "EPPPP", "TPFPT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 1));
        this.addRecipe(new CarBuilderWoodCarBig(BlockPlanks.EnumType.BIRCH), "WSSUC", "EPPPP", "TPFPT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 2));
        this.addRecipe(new CarBuilderWoodCarBig(BlockPlanks.EnumType.JUNGLE), "WSSUC", "EPPPP", "TPFPT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 3));
        this.addRecipe(new CarBuilderWoodCarBig(BlockPlanks.EnumType.ACACIA), "WSSUC", "EPPPP", "TPFPT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 4));
        this.addRecipe(new CarBuilderWoodCarBig(BlockPlanks.EnumType.DARK_OAK), "WSSUC", "EPPPP", "TPFPT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack((Item)ModItems.CAR_BODY_PART_WOOD, 1, 5));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.addRecipe(new CarBuilderTransporter(false, color), "WSUCC", "EPPPP", "TXFTT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack(Blocks.field_150406_ce, 1, color.func_176765_a()));
            this.addRecipe(new CarBuilderTransporter(true, color), "WSUCO", "EPPPP", "TXFTT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_3_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('O'), new ItemStack((Item)ModItems.CONTAINER), Character.valueOf('P'), new ItemStack(Blocks.field_150406_ce, 1, color.func_176765_a()));
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.addRecipe(new CarBuilderSport(color), "XWSUC", "EPPPP", "TXFXT", Character.valueOf('W'), new ItemStack((Item)ModItems.WINDSHIELD), Character.valueOf('S'), new ItemStack((Item)ModItems.CAR_SEAT), Character.valueOf('E'), new ItemStack((Item)ModItems.ENGINE_6_CYLINDER), Character.valueOf('T'), new ItemStack((Item)ModItems.AXLE), Character.valueOf('U'), new ItemStack((Item)ModItems.CONTROL_UNIT), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('F'), new ItemStack((Item)ModItems.CAR_TANK), Character.valueOf('P'), new ItemStack(Blocks.field_150406_ce, 1, color.func_176765_a()));
        }
    }

    public void addRecipe(ICarbuilder builder, Object ... recipeComponents) {
        String pattern = new String();
        int offset = 0;
        while (recipeComponents[offset] instanceof String) {
            pattern = pattern + recipeComponents[offset];
            if (++offset < recipeComponents.length) continue;
        }
        HashMap<Character, ItemStack> map = new HashMap<Character, ItemStack>();
        for (int i = offset; i < recipeComponents.length; i += 2) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            if (itemstack == null) continue;
            map.put(character, itemstack);
        }
        ItemStack[] stackPattern = new ItemStack[pattern.length()];
        for (int i = 0; i < stackPattern.length; ++i) {
            Character character = Character.valueOf(pattern.charAt(i));
            stackPattern[i] = map.containsKey(character) ? ((ItemStack)map.get(character)).func_77946_l() : null;
        }
        ShapedCarRecipe recipe = new ShapedCarRecipe(stackPattern, builder);
        this.recipes.add(recipe);
    }

    public void addRecipe(ICarRecipe recipe) {
        this.recipes.add(recipe);
    }

    @Nullable
    public ICarbuilder findMatchingRecipe(ICarCraftingInventory craftMatrix) {
        for (ICarRecipe irecipe : this.recipes) {
            if (!irecipe.matches(craftMatrix)) continue;
            return irecipe.getCraftingResult();
        }
        return null;
    }

    public List<ICarRecipe> getRecipeList() {
        return this.recipes;
    }

    public ICarRecipe getReciepeByName(String name) {
        for (ICarRecipe reciepe : this.recipes) {
            if (!reciepe.getName().equals(name)) continue;
            return reciepe;
        }
        return null;
    }
}

