/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import de.maxhenkel.tools.Selector;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemStackSelector
implements Selector<ItemStack> {
    private Item item;
    private int meta;

    public ItemStackSelector(Item item, int meta) {
        this.item = item;
        this.meta = meta;
    }

    public ItemStackSelector(Item item) {
        this.item = item;
        this.meta = -1;
    }

    @Nullable
    public static ItemStackSelector fromString(String str) {
        String[] split = str.split(":");
        if (split.length < 2) {
            return null;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
        if (item == null) {
            return null;
        }
        int meta = -1;
        if (split.length >= 3) {
            try {
                meta = Integer.parseInt(split[2]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ItemStackSelector(item, meta);
    }

    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public String toString() {
        if (this.item == null) {
            return "";
        }
        ResourceLocation loc = this.item.getRegistryName();
        String str = loc.func_110624_b() + ":" + loc.func_110623_a();
        if (this.meta >= 0) {
            str = str + ":" + this.meta;
        }
        return str;
    }

    @Override
    public boolean isValid(ItemStack stack) {
        if (this.item == null || stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (!this.item.equals(stack.func_77973_b())) {
            return false;
        }
        if (this.meta < 0) {
            return true;
        }
        return this.meta == stack.func_77960_j();
    }
}

