/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemTools {
    public static final ItemStack EMPTY = null;

    public static boolean isStackEmpty(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.func_77973_b().equals(Blocks.field_150350_a)) {
            return true;
        }
        return stack.field_77994_a <= 0;
    }

    public static boolean areItemsEqualWithEmpty(ItemStack stack1, ItemStack stack2) {
        if (ItemTools.isStackEmpty(stack1) && ItemTools.isStackEmpty(stack2)) {
            return true;
        }
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean contains(List<ItemStack> list, ItemStack item) {
        for (ItemStack i : list) {
            if (!ItemTools.areItemsEqual(item, i)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack itemStackAmount(int amount, ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return null;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        stack.field_77994_a += amount;
        if (stack.field_77994_a <= 0) {
            stack.field_77994_a = 0;
            return null;
        }
        if (stack.field_77994_a > stack.func_77976_d()) {
            stack.field_77994_a = stack.func_77976_d();
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, EntityPlayer player) {
        return ItemTools.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, EntityPlayer player) {
        return ItemTools.itemStackAmount(1, stack, player);
    }

    public static ItemStack damageStack(ItemStack stack, int amount, EntityLivingBase entity) {
        stack.func_77972_a(amount, entity);
        return stack;
    }

    public static void removeStackFromSlot(IInventory inventory, int index) {
        inventory.func_70299_a(index, null);
    }

    public static void saveInventory(NBTTagCompound compound, String name, IInventory inv) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", i);
            inv.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a(name, (NBTBase)nbttaglist);
    }

    public static void readInventory(NBTTagCompound compound, String name, IInventory inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        NBTTagList nbttaglist = compound.func_150295_c(name, 10);
        if (nbttaglist == null) {
            return;
        }
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74762_e("Slot");
            if (j < 0 || j >= inv.func_70302_i_()) continue;
            inv.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
    }
}

