/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.BlockPosList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityCable
extends TileEntityBase
implements ITickable,
IEnergyReceiver {
    private final int transferRate;

    public TileEntityCable(int transferRate) {
        this.transferRate = transferRate;
    }

    public TileEntityCable() {
        this(Config.cableTransferRate);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int energy = 0;
        HashMap<IEnergyProvider, EnumFacing> providers = new HashMap<IEnergyProvider, EnumFacing>();
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyProvider provider = this.getEnergyProvider(facing);
            if (provider == null) continue;
            int cex = Math.max(0, this.transferRate - energy);
            if (cex <= 0) break;
            int extract = provider.extractEnergy(facing.func_176734_d(), cex, true);
            if (extract <= 0) continue;
            energy += extract;
            providers.put(provider, facing.func_176734_d());
        }
        if (energy <= 0) {
            return;
        }
        HashMap<IEnergyReceiver, EnumFacing> receivers = new HashMap<IEnergyReceiver, EnumFacing>();
        this.getConnectedReceivers(receivers, new BlockPosList(), this.field_174879_c);
        if (receivers.size() <= 0) {
            return;
        }
        int split = energy / receivers.size();
        if (split <= 0) {
            return;
        }
        int received = 0;
        for (Map.Entry entry : receivers.entrySet()) {
            received += ((IEnergyReceiver)entry.getKey()).receiveEnergy((EnumFacing)entry.getValue(), split, false);
        }
        for (Map.Entry entry : providers.entrySet()) {
            if (received <= 0) break;
            received -= ((IEnergyProvider)entry.getKey()).extractEnergy((EnumFacing)entry.getValue(), received, false);
        }
    }

    public void drainProvider(IEnergyProvider provider) {
    }

    public void getConnectedReceivers(Map<IEnergyReceiver, EnumFacing> receivers, BlockPosList positions, BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            IEnergyReceiver receiver;
            BlockPos p = pos.func_177972_a(side);
            if (positions.contains(p)) continue;
            positions.add(p);
            IBlockState state = this.field_145850_b.func_180495_p(p);
            if (state.func_177230_c().equals((Object)ModBlocks.CABLE)) {
                this.getConnectedReceivers(receivers, positions, p);
                continue;
            }
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof IEnergyReceiver) || (receiver = (IEnergyReceiver)te).equals(this)) continue;
            receivers.put(receiver, side.func_176734_d());
        }
    }

    @Nullable
    public IEnergyReceiver getEnergyReciever(EnumFacing side) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (te instanceof IEnergyReceiver) {
            return (IEnergyReceiver)te;
        }
        return null;
    }

    @Nullable
    public IEnergyProvider getEnergyProvider(EnumFacing side) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (te instanceof IEnergyProvider) {
            return (IEnergyProvider)te;
        }
        return null;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }
}

