/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.BlockCarWorkshopOutter;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.reciepe.CarCraftingManager;
import de.maxhenkel.car.reciepe.ICarCraftingInventory;
import de.maxhenkel.car.reciepe.ICarbuilder;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.tools.ItemTools;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityCarWorkshop
extends TileEntityBase
implements ICarCraftingInventory {
    private InventoryBasic craftingMatrix = new InventoryBasic(this.func_145748_c_().func_150254_d(), false, 15);
    private InventoryBasic repairInventory = new InventoryBasic(this.func_145748_c_().func_150254_d(), false, 3);
    private EntityCarBase currentCraftingCar;

    public TileEntityCarWorkshop() {
        this.updateRecipe();
    }

    public InventoryBasic getRepairInventory() {
        return this.repairInventory;
    }

    public EntityCarBase getCarOnTop() {
        IBlockState ownState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!ownState.func_177230_c().equals((Object)ModBlocks.CAR_WORKSHOP)) {
            return null;
        }
        BlockPos start = this.func_174877_v().func_177972_a(EnumFacing.UP);
        AxisAlignedBB aabb = new AxisAlignedBB((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p(), (double)(start.func_177958_n() + 1), (double)(start.func_177956_o() + 1), (double)(start.func_177952_p() + 1));
        List cars = this.field_145850_b.func_72872_a(EntityCarBase.class, aabb);
        if (cars.isEmpty()) {
            return null;
        }
        return (EntityCarBase)((Object)cars.get(0));
    }

    public void spawnCar(EntityPlayer player) {
        if (!this.areBlocksAround()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.incomplete_structure", new Object[0]));
            return;
        }
        if (!this.isTopFree()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.blocks_on_top", new Object[0]));
            return;
        }
        this.updateRecipe();
        EntityCarBase car = this.currentCraftingCar;
        if (car == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_reciepe", new Object[0]));
            return;
        }
        BlockPos spawnPos = this.field_174879_c.func_177984_a();
        car.func_70107_b((float)spawnPos.func_177958_n() + car.field_70130_N / 2.0f, spawnPos.func_177956_o(), (float)spawnPos.func_177952_p() + car.field_70130_N / 2.0f);
        this.removeCraftItems();
        this.field_145850_b.func_72838_d((Entity)car);
    }

    public void checkValidity() {
        if (this.areBlocksAround()) {
            this.placeStructure();
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.car_workshop.name", new Object[0]);
    }

    private void placeStructure() {
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, 0, -1), this.getState(1));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, -1), this.getState(2));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, 0), this.getState(3));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, 1), this.getState(4));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, 0, 1), this.getState(5));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, 1), this.getState(6));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, 0), this.getState(7));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, -1), this.getState(8));
        this.setOwnBlockValid(true);
    }

    private void setOwnBlockValid(boolean valid) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!state.func_177230_c().equals((Object)ModBlocks.CAR_WORKSHOP)) {
            return;
        }
        ModBlocks.CAR_WORKSHOP.setValid(this.field_145850_b, this.field_174879_c, state, valid);
    }

    private IBlockState getState(int meta) {
        return ModBlocks.CAR_WORKSHOP_OUTTER.func_176223_P().func_177226_a((IProperty)BlockCarWorkshopOutter.POSITION, (Comparable)Integer.valueOf(meta));
    }

    public boolean areBlocksAround() {
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(0, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(1, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(0, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(-1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(-1, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(-1, 0, 1))) {
            return false;
        }
        return this.checkSideBlock(this.field_174879_c.func_177982_a(1, 0, -1));
    }

    public boolean isTopFree() {
        for (int x = this.field_174879_c.func_177958_n() - 1; x <= this.field_174879_c.func_177958_n() + 1; ++x) {
            for (int y = this.field_174879_c.func_177956_o() + 1; y <= this.field_174879_c.func_177958_n() + 2; ++y) {
                for (int z = this.field_174879_c.func_177952_p() - 1; z <= this.field_174879_c.func_177952_p() + 1; ++z) {
                    if (this.checkBlockAir(new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkBlockAir(BlockPos p) {
        return this.field_145850_b.func_175623_d(p);
    }

    private boolean checkSideBlock(BlockPos p) {
        IBlockState state = this.field_145850_b.func_180495_p(p);
        return state.func_177230_c().equals((Object)ModBlocks.CAR_WORKSHOP_OUTTER);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemTools.saveInventory(compound, "crafting", (IInventory)this.craftingMatrix);
        ItemTools.saveInventory(compound, "repair", (IInventory)this.repairInventory);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        ItemTools.readInventory(compound, "crafting", (IInventory)this.craftingMatrix);
        ItemTools.readInventory(compound, "repair", (IInventory)this.repairInventory);
        super.func_145839_a(compound);
    }

    public void updateRecipe() {
        ICarbuilder builder = this.getCurrentRecipe();
        if (builder == null) {
            this.currentCraftingCar = null;
            return;
        }
        this.currentCraftingCar = builder.build(this.field_145850_b);
    }

    @Nullable
    public ICarbuilder getCurrentRecipe() {
        return CarCraftingManager.getInstance().findMatchingRecipe(this);
    }

    public void removeCraftItems() {
        for (int i = 0; i < this.craftingMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftingMatrix.func_70301_a(i);
            if (ItemTools.isStackEmpty(stack)) continue;
            this.craftingMatrix.func_70299_a(i, ItemTools.decrItemStack(stack, null));
        }
    }

    public String func_70005_c_() {
        return this.craftingMatrix.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.craftingMatrix.func_145818_k_();
    }

    public int func_70302_i_() {
        return this.craftingMatrix.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.craftingMatrix.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.craftingMatrix.func_70298_a(index, count);
        this.updateRecipe();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.craftingMatrix.func_70304_b(index);
        this.updateRecipe();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.craftingMatrix.func_70299_a(index, stack);
        this.updateRecipe();
    }

    public int func_70297_j_() {
        return this.craftingMatrix.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.craftingMatrix.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.craftingMatrix.func_191420_l();
    }

    public void func_174889_b(EntityPlayer player) {
        this.craftingMatrix.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.craftingMatrix.func_174889_b(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.craftingMatrix.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return this.craftingMatrix.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.craftingMatrix.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.craftingMatrix.func_174890_g();
    }

    public void func_174888_l() {
        this.craftingMatrix.func_174888_l();
        this.updateRecipe();
    }

    @Override
    public ItemStack getStackInRowAndColumn(int row, int column) {
        return row >= 0 && row < 5 && column >= 0 && column <= 3 ? this.func_70301_a(row + column * 5) : ItemTools.EMPTY;
    }

    public EntityCarBase getCurrentCraftingCar() {
        return this.currentCraftingCar;
    }

    public void repairCar(EntityPlayer player) {
        if (!this.areBlocksAround()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.incomplete_structure", new Object[0]));
            return;
        }
        if (!this.areRepairItemsInside()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_repair_items", new Object[0]));
            return;
        }
        EntityCarBase carBase = this.getCarOnTop();
        if (!(carBase instanceof EntityCarDamageBase)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.no_car", new Object[0]));
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carBase;
        if (car.getDamage() <= 0.0f) {
            return;
        }
        this.damageRepairItemsInside(player);
        car.setDamage(car.getDamage() - 10.0f);
        ModSounds.playSound(SoundEvents.field_187698_i, this.field_145850_b, this.field_174879_c, null, SoundCategory.BLOCKS);
    }

    public boolean areRepairItemsInside() {
        for (int i = 0; i < this.repairInventory.func_70302_i_(); ++i) {
            if (!ItemTools.isStackEmpty(this.repairInventory.func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    public void damageRepairItemsInside(EntityPlayer player) {
        for (int i = 0; i < this.repairInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.repairInventory.func_70301_a(i);
            if (ItemTools.isStackEmpty(stack)) continue;
            ItemTools.damageStack(stack, 10, (EntityLivingBase)player);
        }
    }
}

