/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.energy.EnergyUtil;
import de.maxhenkel.car.registries.GeneratorRecipe;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityGenerator
extends TileEntityBase
implements ITickable,
IFluidHandler,
IEnergyProvider,
IInventory {
    public final int maxStorage;
    public int storedEnergy = 0;
    public final int maxMillibuckets;
    protected int currentMillibuckets = 0;
    protected Fluid currentFluid;
    protected InventoryBasic inventory = new InventoryBasic("", false, 0);

    public TileEntityGenerator() {
        this.maxStorage = Config.generatorEnergyStorage;
        this.maxMillibuckets = Config.generatorFluidStorage;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isEnabled()) {
            this.setBlockEnabled(true);
        } else {
            this.setBlockEnabled(false);
        }
        if (this.currentFluid != null && this.currentMillibuckets > 0 && this.storedEnergy + this.getCurrentGenerationFactor() <= this.maxStorage) {
            --this.currentMillibuckets;
            this.storedEnergy += this.getCurrentGenerationFactor();
            if (this.currentMillibuckets <= 0) {
                this.currentMillibuckets = 0;
                this.currentFluid = null;
            }
        }
        if (this.currentMillibuckets <= 0 && this.currentFluid != null) {
            this.currentMillibuckets = 0;
            this.currentFluid = null;
        }
        if (this.currentFluid == null && this.currentMillibuckets > 0) {
            this.currentMillibuckets = 0;
        }
        this.handlePushEnergy();
        this.func_70296_d();
    }

    public int getCurrentGenerationFactor(Fluid f) {
        for (GeneratorRecipe recipe : GeneratorRecipe.REGISTRY) {
            if (!recipe.getInput().isValid(f)) continue;
            return recipe.getEnergy();
        }
        return 0;
    }

    public int getCurrentGenerationFactor() {
        return this.getCurrentGenerationFactor(this.currentFluid);
    }

    public boolean isValidFuel(Fluid f) {
        return this.getCurrentGenerationFactor(f) > 0;
    }

    private void handlePushEnergy() {
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (!(te instanceof IEnergyReceiver)) continue;
            IEnergyReceiver rec = (IEnergyReceiver)te;
            EnergyUtil.pushEnergy(this, rec, this.storedEnergy, side.func_176734_d(), side);
        }
    }

    public boolean isEnabled() {
        int fuelGen = this.getCurrentGenerationFactor();
        return this.currentMillibuckets > 0 && this.storedEnergy + fuelGen < this.maxStorage;
    }

    public void setBlockEnabled(boolean enabled) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c().equals((Object)ModBlocks.GENERATOR) && (Boolean)state.func_177229_b((IProperty)BlockGui.POWERED) != enabled) {
            ModBlocks.GENERATOR.setPowered(this.field_145850_b, this.field_174879_c, state, enabled);
        }
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.storedEnergy;
            }
            case 1: {
                return this.currentMillibuckets;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.storedEnergy = value;
                break;
            }
            case 1: {
                this.currentMillibuckets = value;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("stored_energy", this.storedEnergy);
        if (this.currentFluid != null) {
            FluidStack stack = new FluidStack(this.currentFluid, this.currentMillibuckets);
            NBTTagCompound comp = new NBTTagCompound();
            stack.writeToNBT(comp);
            compound.func_74782_a("fluid", (NBTBase)comp);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.storedEnergy = compound.func_74762_e("stored_energy");
        if (compound.func_74764_b("fluid")) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid"));
            this.currentFluid = stack.getFluid();
            this.currentMillibuckets = stack.amount;
        }
        super.func_145839_a(compound);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.generator.name", new Object[0]);
    }

    public int func_174890_g() {
        return 2;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.func_70296_d();
        }
        return i;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.maxStorage;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                if (TileEntityGenerator.this.currentFluid == null) {
                    return null;
                }
                return new FluidStack(TileEntityGenerator.this.currentFluid, TileEntityGenerator.this.currentMillibuckets);
            }

            public int getCapacity() {
                return TileEntityGenerator.this.maxMillibuckets;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return TileEntityGenerator.this.isValidFuel(fluidStack.getFluid()) && (TileEntityGenerator.this.currentFluid == null || TileEntityGenerator.this.currentFluid.equals(fluidStack.getFluid()));
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrain() {
                return false;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.currentFluid == null && this.isValidFuel(resource.getFluid()) || resource.getFluid().equals(this.currentFluid)) {
            int amount = Math.min(this.maxMillibuckets - this.currentMillibuckets, resource.amount);
            if (doFill) {
                this.currentMillibuckets += amount;
                if (this.currentFluid == null) {
                    this.currentFluid = resource.getFluid();
                }
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

