/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.IDrivable;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.net.MessageStartCar;
import de.maxhenkel.car.proxy.CommonProxy;
import de.maxhenkel.car.reciepe.CarCraftingManager;
import de.maxhenkel.car.reciepe.ICarRecipe;
import de.maxhenkel.car.reciepe.ICarbuilder;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopHigh;
import de.maxhenkel.car.sounds.SoundLoopIdle;
import de.maxhenkel.car.sounds.SoundLoopStart;
import de.maxhenkel.tools.ItemTools;
import de.maxhenkel.tools.MathTools;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityCarBase
extends EntityVehicleBase {
    protected float maxSpeed = 0.5f;
    protected float maxReverseSpeed = 0.2f;
    protected float acceleration = 0.032f;
    protected float maxRotationSpeed = 5.0f;
    protected float rollResistance = 0.02f;
    protected float minRotationSpeed = 2.0f;
    private float wheelRotation;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopIdle idleLoop;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopHigh highLoop;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopStart startLoop;
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> STARTED = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FORWARD = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BACKWARD = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LEFT = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIGHT = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityCarBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.6f);
        this.field_70138_W = Config.carStepHeight;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isStarted() && !this.canEngineStayOn()) {
            this.setStarted(false);
        }
        this.updateGravity();
        this.controlCar();
        this.checkPush();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            this.updateSounds();
        }
    }

    public void checkPush() {
        if (this.func_70046_E() == null) {
            return;
        }
        List list = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_70046_E().func_72314_b(0.2, 0.0, 0.2), EntitySelectors.func_188442_a((Entity)this));
        for (int j = 0; j < list.size(); ++j) {
            EntityPlayer player = (EntityPlayer)list.get(j);
            if (player.func_184196_w((Entity)this) || !player.func_70093_af()) continue;
            double motX = EntityCarBase.calculateMotionX(0.05f, player.field_70177_z);
            double motZ = EntityCarBase.calculateMotionZ(0.05f, player.field_70177_z);
            this.func_70091_d(MoverType.PLAYER, motX, 0.0, motZ);
            return;
        }
    }

    public boolean canEngineStayOn() {
        return !this.func_70090_H() && !this.func_180799_ab();
    }

    public void updateSounds() {
        if (this.getSpeed() == 0.0f && this.isStarted()) {
            this.checkIdleLoop();
        }
        if (this.getSpeed() != 0.0f && this.isStarted()) {
            this.checkHighLoop();
        }
    }

    public void destroyCar(EntityPlayer player, boolean dropParts) {
        if (dropParts) {
            ICarbuilder builder = this.getBuilder();
            ICarRecipe reciepe = CarCraftingManager.getInstance().getReciepeByName(builder.getName());
            if (reciepe != null) {
                for (ItemStack stack : reciepe.getInputs()) {
                    if (ItemTools.isStackEmpty(stack) || !this.shouldDropItemWithChance(stack)) continue;
                    InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)stack);
                }
            }
        }
        this.func_70106_y();
    }

    public boolean shouldDropItemWithChance(ItemStack stack) {
        return this.field_70146_Z.nextInt(10) != 0;
    }

    public abstract ICarbuilder getBuilder();

    private void controlCar() {
        if (!this.func_184207_aI()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        float modifier = 1.0f;
        if (Config.carGroundSpeed) {
            modifier = this.getModifier();
        }
        float maxSp = this.maxSpeed * modifier;
        float maxBackSp = this.maxReverseSpeed * modifier;
        float speed = MathTools.subtractToZero(this.getSpeed(), this.rollResistance);
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.acceleration, maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.acceleration, -maxBackSp);
        }
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = MathHelper.func_76135_e((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = MathHelper.func_76131_a((float)rotationSpeed, (float)this.minRotationSpeed, (float)this.maxRotationSpeed);
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.field_70177_z += this.deltaRotation;
        if (this.field_70177_z > 180.0f) {
            this.field_70177_z -= 360.0f;
            this.field_70126_B = this.field_70177_z;
        } else if (this.field_70177_z <= -180.0f) {
            this.field_70177_z += 360.0f;
            this.field_70126_B = this.field_70177_z;
        }
        if (this.field_70123_F) {
            if (this.field_70170_p.field_72995_K) {
                this.onCollision(speed);
            }
        } else {
            this.field_70159_w = EntityCarBase.calculateMotionX(this.getSpeed(), this.field_70177_z);
            this.field_70179_y = EntityCarBase.calculateMotionZ(this.getSpeed(), this.field_70177_z);
        }
    }

    public float getModifier() {
        BlockPos pos = this.func_180425_c().func_177977_b();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b.equals(Blocks.field_150350_a)) {
            return 1.0f;
        }
        if (!(b instanceof IDrivable)) {
            return 0.5f;
        }
        IDrivable drivable = (IDrivable)b;
        return drivable.getSpeedModifier();
    }

    public abstract float getRotationModifier();

    public void onCollision(float speed) {
        if (this.field_70170_p.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageCrash(speed, this));
        }
        this.setSpeed(0.01f);
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean canPlayerDriveCar(EntityPlayer player) {
        if (player.equals((Object)this.getDriver()) && this.isStarted()) {
            return true;
        }
        if (this.func_70090_H() || this.func_180799_ab()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.func_189652_ae()) {
            this.field_70181_x = 0.0;
            return;
        }
        this.field_70181_x += -0.2;
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, EntityPlayer player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.field_70170_p.field_72995_K && needsUpdate) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageControlCar(forward, backward, left, right, player));
        }
    }

    public void startCarEngine(EntityPlayer player) {
        if (this.isStarted()) {
            this.setStarted(false);
            if (this.field_70170_p.field_72995_K) {
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageStartCar(false, player));
            }
        } else if (this.getDriver() != null && this.canStartCarEngine(this.getDriver())) {
            this.setStarted(true);
            this.checkStartLoop();
            if (this.field_70170_p.field_72995_K) {
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageStartCar(false, player));
            }
        } else {
            this.playEngineFailSound();
            if (this.field_70170_p.field_72995_K) {
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageStartCar(true, player));
            }
        }
    }

    public void startCarEngineServerSide(boolean failed) {
        if (failed) {
            this.playEngineFailSound();
        } else if (this.isStarted()) {
            this.setStarted(false);
        } else {
            this.setStarted(true);
        }
    }

    public boolean canStartCarEngine(EntityPlayer player) {
        return !this.func_70090_H() && !this.func_180799_ab();
    }

    public double func_70042_X() {
        return -0.4;
    }

    public boolean canPlayerEnterCar(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.canPlayerEnterCar(player)) {
            return false;
        }
        return super.func_184230_a(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float updateWheelRotation(float delta) {
        this.wheelRotation += delta * this.getSpeed() * 8.0f;
        return this.wheelRotation;
    }

    public void openCarGUi(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageCarGui(true, player));
        }
    }

    public boolean isAccelerating() {
        boolean b = (this.isForward() || this.isBackward()) && !this.field_70123_F;
        return b && this.isStarted();
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STARTED, (Object)false);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FORWARD, (Object)false);
        this.field_70180_af.func_187214_a(BACKWARD, (Object)false);
        this.field_70180_af.func_187214_a(LEFT, (Object)false);
        this.field_70180_af.func_187214_a(RIGHT, (Object)false);
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
    }

    public void setStarted(boolean started) {
        this.setStarted(started, true);
    }

    public void setStarted(boolean started, boolean playsound) {
        if (!started && playsound) {
            this.playStopSound();
        }
        this.field_70180_af.func_187227_b(STARTED, (Object)started);
    }

    public boolean isStarted() {
        return (Boolean)this.field_70180_af.func_187225_a(STARTED);
    }

    public void setForward(boolean forward) {
        this.field_70180_af.func_187227_b(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.field_70180_af.func_187227_b(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.field_70180_af.func_187227_b(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.field_70180_af.func_187225_a(LEFT);
    }

    public void setRight(boolean right) {
        this.field_70180_af.func_187227_b(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.field_70180_af.func_187225_a(RIGHT);
    }

    public abstract ITextComponent getCarName();

    protected void func_70037_a(NBTTagCompound compound) {
        this.setStarted(compound.func_74767_n("started"), false);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("started", this.isStarted());
    }

    public void playStopSound() {
        ModSounds.playSound(this.getStopSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playEngineFailSound() {
        ModSounds.playSound(this.getFailSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playCrashSound() {
        ModSounds.playSound(this.getCrashSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playHornSound() {
        ModSounds.playSound(this.getHornSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public SoundEvent getStopSound() {
        return ModSounds.engine_stop;
    }

    public SoundEvent getFailSound() {
        return ModSounds.engine_fail;
    }

    public SoundEvent getCrashSound() {
        return ModSounds.car_crash;
    }

    public SoundEvent getStartSound() {
        return ModSounds.engine_start;
    }

    public SoundEvent getIdleSound() {
        return ModSounds.engine_idle;
    }

    public SoundEvent getHighSound() {
        return ModSounds.engine_high;
    }

    public SoundEvent getHornSound() {
        return ModSounds.car_horn;
    }

    public int getStartSoundTime() {
        return 1600;
    }

    @SideOnly(value=Side.CLIENT)
    public void checkIdleLoop() {
        if (this.startLoop != null && !this.startLoop.func_147667_k()) {
            return;
        }
        if (this.idleLoop == null || this.idleLoop.func_147667_k()) {
            this.idleLoop = new SoundLoopIdle(this.field_70170_p, this, this.getIdleSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.idleLoop, this.field_70170_p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void checkHighLoop() {
        if (this.startLoop != null && !this.startLoop.func_147667_k()) {
            return;
        }
        if (this.highLoop == null || this.highLoop.func_147667_k()) {
            this.highLoop = new SoundLoopHigh(this.field_70170_p, this, this.getHighSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.highLoop, this.field_70170_p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void checkStartLoop() {
        if (this.startLoop == null || this.startLoop.func_147667_k()) {
            this.startLoop = new SoundLoopStart(this.field_70170_p, this, this.getStartSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.startLoop, this.field_70170_p);
        }
    }

    public void onHornPressed(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageCarHorn(true, player));
        } else {
            this.playHornSound();
        }
    }
}

