/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiBackmixReactor
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_backmix_reactor.png");
    private static final int fontColor = 0x404040;
    private IInventory playerInv;
    private TileEntityBackmixReactor tile;

    public GuiBackmixReactor(TileEntityBackmixReactor tile, IInventory playerInv) {
        super((Container)new ContainerBackmixReactor(tile, playerInv));
        this.playerInv = playerInv;
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (mouseX >= this.field_147003_i + 11 && mouseX <= this.field_147003_i + 16 + 11 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<String>();
            list.add(new TextComponentTranslation("tooltip.energy", new Object[]{this.tile.func_174887_a_(0)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 33 && mouseX <= this.field_147003_i + 16 + 33 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.oil", new Object[]{this.tile.func_174887_a_(1)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 55 && mouseX <= this.field_147003_i + 16 + 55 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.methanol", new Object[]{this.tile.func_174887_a_(2)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 122 && mouseX <= this.field_147003_i + 16 + 122 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.mix", new Object[]{this.tile.func_174887_a_(3)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 79 && mouseX <= this.field_147003_i + 24 + 79 && mouseY >= this.field_147009_r + 34 && mouseY <= this.field_147009_r + 17 + 34) {
            list = new ArrayList();
            list.add(new TextComponentTranslation("tooltip.progress", new Object[]{(int)(this.getProgress() * 100.0f)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawProgress();
        this.drawEnergy();
        this.drawCanola();
        this.drawMethanol();
        this.drawMix();
    }

    public void drawEnergy() {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawCanola() {
        float perc = this.getCanola();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 33;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMethanol() {
        float perc = this.getMethanol();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 55;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMix() {
        float perc = this.getMix();
        int texX = 224;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress() {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.func_174887_a_(0) / (float)this.tile.maxStorage;
    }

    public float getCanola() {
        return (float)this.tile.func_174887_a_(1) / (float)this.tile.maxCanola;
    }

    public float getMethanol() {
        return (float)this.tile.func_174887_a_(2) / (float)this.tile.maxMethanol;
    }

    public float getMix() {
        return (float)this.tile.func_174887_a_(3) / (float)this.tile.maxMix;
    }

    public float getProgress() {
        if (this.tile.func_174887_a_(4) == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.func_174887_a_(4);
        return (float)time / (float)this.tile.generatingTime;
    }
}

