/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityEnergyFluidProducer;
import de.maxhenkel.car.gui.ContainerEnergyFluidProducer;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class GuiEnergyFluidProducer
extends GuiContainer {
    private static final int fontColor = 0x404040;
    private IInventory playerInv;
    private TileEntityEnergyFluidProducer tile;

    public GuiEnergyFluidProducer(ContainerEnergyFluidProducer container) {
        super((Container)container);
        this.playerInv = container.getPlayerInventory();
        this.tile = container.getTile();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public abstract ResourceLocation getGuiTexture();

    public String getUnlocalizedTooltipEnergy() {
        return "tooltip.energy";
    }

    public String getUnlocalizedTooltipProgress() {
        return "tooltip.progress";
    }

    public abstract String getUnlocalizedTooltipLiquid();

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.tile.func_145748_c_().func_150260_c(), 38, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (mouseX >= this.field_147003_i + 11 && mouseX <= this.field_147003_i + 16 + 11 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<String>();
            list.add(new TextComponentTranslation(this.getUnlocalizedTooltipEnergy(), new Object[]{this.tile.func_174887_a_(1)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 148 && mouseX <= this.field_147003_i + 16 + 148 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TextComponentTranslation(this.getUnlocalizedTooltipLiquid(), new Object[]{this.tile.func_174887_a_(2)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 79 && mouseX <= this.field_147003_i + 24 + 79 && mouseY >= this.field_147009_r + 34 && mouseY <= this.field_147009_r + 17 + 34) {
            list = new ArrayList();
            list.add(new TextComponentTranslation(this.getUnlocalizedTooltipProgress(), new Object[]{(int)(this.getProgress() * 100.0f)}).func_150254_d());
            this.func_146283_a(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void drawEnergy() {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid() {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 148;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress() {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.func_174887_a_(1) / (float)this.tile.getMaxStorage();
    }

    public float getFluid() {
        return (float)this.tile.func_174887_a_(2) / (float)this.tile.getMaxMillibuckets();
    }

    public float getProgress() {
        if (this.tile.func_174887_a_(0) == 0) {
            return 0.0f;
        }
        int time = this.tile.getGeneratingTime() - this.tile.func_174887_a_(0);
        return (float)time / (float)this.tile.getGeneratingTime();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiTexture());
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawEnergy();
        this.drawFluid();
        this.drawProgress();
    }

    public boolean func_73868_f() {
        return false;
    }
}

