/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.gui.ContainerFuelStation;
import de.maxhenkel.tools.MathTools;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;

public class GuiFuelStation
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_fuelstation.png");
    private TileEntityFuelStation fuelStation;
    protected int field_146999_f = 248;
    protected int field_147000_g = 166;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    private static final ChatFormatting INFO_COLOR = ChatFormatting.WHITE;
    protected int field_147003_i;
    protected int field_147009_r;
    protected GuiButton buttonStart;
    protected GuiButton buttonStop;

    public GuiFuelStation(TileEntityFuelStation fuelStation) {
        super((Container)new ContainerFuelStation(fuelStation));
        this.fuelStation = fuelStation;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.buttonStart = this.func_189646_b(new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + this.field_147000_g - 20 - 15, 75, 20, new TextComponentTranslation("button.start", new Object[0]).func_150254_d()));
        this.buttonStop = this.func_189646_b(new GuiButton(1, this.field_147003_i + this.field_146999_f - 75 - 15, this.field_147009_r + this.field_147000_g - 20 - 15, 75, 20, new TextComponentTranslation("button.stop", new Object[0]).func_150254_d()));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.buttonStart.field_146124_l = !this.fuelStation.isFueling();
        this.buttonStop.field_146124_l = this.fuelStation.isFueling();
        this.func_73732_a(this.field_146289_q, new TextComponentTranslation("gui.fuelstation", new Object[0]).func_150254_d(), this.field_146294_l / 2, this.field_147009_r + 10, TITLE_COLOR);
        EntityCarFuelBase car = this.fuelStation.getCarInFront();
        this.drawCarName(car);
        this.drawCarFuel(car);
        this.drawRefueled();
        this.drawBuffer();
    }

    private void drawCarName(EntityCarFuelBase car) {
        String carText = car == null ? new TextComponentTranslation("fuelstation.nocar", new Object[0]).func_150254_d() : new TextComponentTranslation("fuelstation.carinfo", new Object[]{INFO_COLOR + car.getCarName().func_150254_d()}).func_150254_d();
        this.field_146289_q.func_78276_b(carText, this.field_146294_l / 2 - 10, this.field_147009_r + 40, FONT_COLOR);
    }

    private void drawCarFuel(EntityCarFuelBase car) {
        if (car == null) {
            String empty = new TextComponentTranslation("fuelstation.fuel_empty", new Object[0]).func_150254_d();
            this.field_146289_q.func_78276_b(empty, this.field_146294_l / 2 - 10, this.field_147009_r + 50, FONT_COLOR);
            return;
        }
        String fuelText = new TextComponentTranslation("fuelstation.car_fuel_amount", new Object[]{INFO_COLOR + String.valueOf(MathTools.round(car.getFuelAmount(), 2)), INFO_COLOR + String.valueOf(MathTools.round(car.getMaxFuel(), 2))}).func_150254_d();
        this.field_146289_q.func_78276_b(fuelText, this.field_146294_l / 2 - 10, this.field_147009_r + 50, FONT_COLOR);
        if (car.getFluid() == null) {
            return;
        }
        String typeText = new TextComponentTranslation("fuelstation.car_fuel_type", new Object[]{INFO_COLOR + car.getFluid().getLocalizedName(new FluidStack(car.getFluid(), 1))}).func_150254_d();
        this.field_146289_q.func_78276_b(typeText, this.field_146294_l / 2 - 10, this.field_147009_r + 60, FONT_COLOR);
    }

    private void drawRefueled() {
        String refueledText = new TextComponentTranslation("fuelstation.refueled", new Object[]{INFO_COLOR + String.valueOf(MathTools.round(this.fuelStation.func_174887_a_(0), 2))}).func_150254_d();
        this.field_146289_q.func_78276_b(refueledText, this.field_146294_l / 2 - 10, this.field_147009_r + 80, FONT_COLOR);
    }

    private void drawBuffer() {
        FluidStack stack = this.fuelStation.getStorage();
        if (stack == null) {
            String bufferText = new TextComponentTranslation("fuelstation.fuel_empty", new Object[0]).func_150254_d();
            this.field_146289_q.func_78276_b(bufferText, this.field_146294_l / 2 - 10, this.field_147009_r + 90, FONT_COLOR);
            return;
        }
        int amount = this.fuelStation.func_174887_a_(1);
        String amountText = new TextComponentTranslation("fuelstation.fuel_buffer_amount", new Object[]{INFO_COLOR + String.valueOf(amount), INFO_COLOR + String.valueOf(this.fuelStation.maxStorageAmount)}).func_150254_d();
        this.field_146289_q.func_78276_b(amountText, this.field_146294_l / 2 - 10, this.field_147009_r + 90, FONT_COLOR);
        String fluidName = stack.getLocalizedName();
        String bufferText = new TextComponentTranslation("fuelstation.fuel_buffer_type", new Object[]{INFO_COLOR + fluidName}).func_150254_d();
        this.field_146289_q.func_78276_b(bufferText, this.field_146294_l / 2 - 10, this.field_147009_r + 100, FONT_COLOR);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.equals(this.buttonStart)) {
            this.fuelStation.setFueling(true);
            this.fuelStation.sendStartFuelPacket(true);
        } else if (button.equals(this.buttonStop)) {
            this.fuelStation.setFueling(false);
            this.fuelStation.sendStartFuelPacket(false);
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

