/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageControlCar
implements IMessage,
IMessageHandler<MessageControlCar, IMessage> {
    private boolean forward;
    private boolean backward;
    private boolean left;
    private boolean right;
    private UUID uuid;

    public MessageControlCar() {
        this.forward = false;
        this.backward = false;
        this.left = false;
        this.right = false;
        this.uuid = new UUID(0L, 0L);
    }

    public MessageControlCar(boolean forward, boolean backward, boolean left, boolean right, EntityPlayer player) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.uuid = player.func_110124_au();
    }

    public IMessage onMessage(MessageControlCar message, MessageContext ctx) {
        if (ctx.side.equals((Object)Side.SERVER)) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!player.func_110124_au().equals(message.uuid)) {
                return null;
            }
            Entity e = player.func_184187_bx();
            if (!(e instanceof EntityCarBase)) {
                return null;
            }
            EntityCarBase car = (EntityCarBase)e;
            car.updateControls(message.forward, message.backward, message.left, message.right, (EntityPlayer)player);
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.forward = buf.readBoolean();
        this.backward = buf.readBoolean();
        this.left = buf.readBoolean();
        this.right = buf.readBoolean();
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.uuid = new UUID(l1, l2);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.backward);
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public boolean isLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.right;
    }
}

