/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools.json;

import de.maxhenkel.tools.json.JSONArray;
import de.maxhenkel.tools.json.JSONException;
import de.maxhenkel.tools.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class JsonConfig {
    private File file;
    private JSONObject jsonObject;

    public JsonConfig(String filename) {
        this(new File(filename));
    }

    public JsonConfig(File file) {
        this.file = file;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            this.jsonObject = new JSONObject(IOUtils.toString((InputStream)inputStream));
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            this.jsonObject = new JSONObject();
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.jsonObject = new JSONObject();
        }
    }

    public boolean put(String key, Object value) {
        try {
            this.jsonObject.put(key, value);
            this.save();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putStringList(String key, List<String> value) {
        try {
            return this.put(key, new JSONArray(value));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object get(String key, Object defValue) {
        Object o = null;
        try {
            o = this.jsonObject.get(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (o == null) {
            this.put(key, defValue);
            return defValue;
        }
        return o;
    }

    public JSONArray getJsonArray(String key, JSONArray defValue) {
        JSONArray o = null;
        try {
            o = this.jsonObject.getJSONArray(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (o == null) {
            this.put(key, defValue);
            return defValue;
        }
        return o;
    }

    public JSONObject getJsonObject(String key, JSONObject defValue) {
        JSONObject o = null;
        try {
            o = this.jsonObject.getJSONObject(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (o == null) {
            this.put(key, defValue);
            return defValue;
        }
        return o;
    }

    public int getInt(String key, int defValue) {
        try {
            return this.jsonObject.getInt(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
    }

    public String getString(String key, String defValue) {
        try {
            return this.jsonObject.getString(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
    }

    public boolean getBoolean(String key, boolean defValue) {
        try {
            return this.jsonObject.getBoolean(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
    }

    public double getDouble(String key, double defValue) {
        try {
            return this.jsonObject.getDouble(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
    }

    public long getLong(String key, long defValue) {
        try {
            return this.jsonObject.getLong(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
    }

    public List<String> getStringList(String key, List<String> defValue) {
        JSONArray jArray;
        ArrayList<String> l = new ArrayList<String>();
        try {
            jArray = this.jsonObject.getJSONArray(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
        for (int i = 0; i < jArray.length(); ++i) {
            try {
                l.add(jArray.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return l;
    }

    public String[] getStringArray(String key, String[] defValue) {
        JSONArray jArray;
        try {
            jArray = this.jsonObject.getJSONArray(key);
        }
        catch (JSONException e) {
            this.put(key, defValue);
            return defValue;
        }
        String[] out = new String[jArray.length()];
        for (int i = 0; i < jArray.length(); ++i) {
            try {
                out[i] = jArray.getString(i);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return out;
    }

    private void save() throws IOException, JSONException {
        File f = new File(this.file.getAbsolutePath());
        if (f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        IOUtils.write((String)this.jsonObject.toString(1), (OutputStream)new FileOutputStream(f));
    }

    public String toString() {
        return "Config: " + this.file.getAbsolutePath();
    }
}

