/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.ModCreativeTabs;
import de.maxhenkel.car.blocks.BlockFuelStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.BlockTank;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockFuelStation
extends BlockOrientableHorizontal {
    public static final AxisAlignedBB AABB_NORTH_SOUTH = new AxisAlignedBB(0.125, 0.0, 0.3125, 0.875, 1.9375, 0.6875);
    public static final AxisAlignedBB AABB_EAST_WEST = new AxisAlignedBB(0.3125, 0.0, 0.125, 0.6875, 1.9375, 0.875);
    public static final AxisAlignedBB AABB_SLAB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockFuelStation() {
        super(Material.field_151573_f, MapColor.field_151668_h);
        this.func_149663_c("fuelstation");
        this.setRegistryName("fuelstation");
        this.func_149711_c(4.0f);
        this.func_149752_b(50.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(ModCreativeTabs.TAB_CAR);
        this.field_149783_u = true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityFuelStation)) {
            return false;
        }
        TileEntityFuelStation station = (TileEntityFuelStation)te;
        ItemStack stack = playerIn.func_184586_b(hand);
        if ((station.isOwner(playerIn) || !station.hasTrade()) && stack != null) {
            boolean success1;
            boolean success;
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack != null && (success = BlockTank.handleEmpty(stack, worldIn, pos, playerIn, hand))) {
                return true;
            }
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
            if (handler != null && (success1 = BlockTank.handleFill(stack, worldIn, pos, playerIn, hand))) {
                return true;
            }
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)Main.instance(), 3, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (station.isOwner(playerIn)) {
            playerIn.openGui((Object)Main.instance(), 13, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFuelStation();
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing.equals((Object)EnumFacing.NORTH) || facing.equals((Object)EnumFacing.SOUTH)) {
            return AABB_NORTH_SOUTH;
        }
        return AABB_EAST_WEST;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        BlockFuelStation.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
        BlockFuelStation.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SLAB);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        return super.func_176196_c(worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), ModBlocks.FUEL_STATION_TOP.func_176223_P().func_177226_a((IProperty)BlockFuelStationTop.FACING, state.func_177229_b((IProperty)FACING)));
        }
        if ((te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityFuelStation && placer instanceof EntityPlayer) {
            TileEntityFuelStation station = (TileEntityFuelStation)te;
            station.setOwner((EntityPlayer)placer);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        IBlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
        if (stateUp != null && stateUp.func_177230_c() != null && stateUp.func_177230_c().equals((Object)ModBlocks.FUEL_STATION_TOP)) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
        BlockFuelStation.dropItems(worldIn, pos);
    }

    public static void dropItems(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFuelStation) {
            TileEntityFuelStation station = (TileEntityFuelStation)te;
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)station.getInventory());
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)station.getTradingInventory());
        }
    }
}

