/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.DamageSourceCar;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.proxy.CommonProxy;
import de.maxhenkel.car.reciepe.ICarbuilder;
import de.maxhenkel.car.registries.CarProperties;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopHigh;
import de.maxhenkel.car.sounds.SoundLoopIdle;
import de.maxhenkel.car.sounds.SoundLoopStart;
import de.maxhenkel.tools.MathTools;
import de.maxhenkel.tools.Teleport;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityCarBase
extends EntityVehicleBase {
    private float maxSpeed = 0.5f;
    protected float maxReverseSpeed = 0.2f;
    protected float acceleration = 0.032f;
    protected float maxRotationSpeed = 5.0f;
    protected float rollResistance = 0.02f;
    protected float minRotationSpeed = 2.0f;
    private float wheelRotation;
    @SideOnly(value=Side.CLIENT)
    private boolean collidedLastTick;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopStart startLoop;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopIdle idleLoop;
    @SideOnly(value=Side.CLIENT)
    private SoundLoopHigh highLoop;
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> STARTED = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FORWARD = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BACKWARD = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LEFT = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIGHT = EntityDataManager.func_187226_a(EntityCarBase.class, (DataSerializer)DataSerializers.field_187198_h);
    @SideOnly(value=Side.CLIENT)
    private boolean startedLast;

    public EntityCarBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.6f);
        this.field_70138_W = Config.carStepHeight;
        for (CarProperties props : CarProperties.REGISTRY) {
            if (!props.getCarID().equals(this.getID())) continue;
            this.maxSpeed = props.getSpeed();
            this.acceleration = props.getAcceleration();
            this.maxReverseSpeed = props.getReverseSpeed();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.handleTeleport();
        if (this.isStarted() && !this.canEngineStayOn()) {
            this.setStarted(false);
        }
        this.updateGravity();
        this.controlCar();
        this.checkPush();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            this.updateSounds();
        }
    }

    public void centerCar() {
        EnumFacing facing = this.func_174811_aO();
        switch (facing) {
            case SOUTH: {
                this.field_70177_z = 0.0f;
                break;
            }
            case NORTH: {
                this.field_70177_z = 180.0f;
                break;
            }
            case EAST: {
                this.field_70177_z = -90.0f;
                break;
            }
            case WEST: {
                this.field_70177_z = 90.0f;
            }
        }
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        float speed;
        if (Config.damageEntities && entityIn.func_174813_aQ().func_72326_a(this.func_70046_E()) && (speed = this.getSpeed()) > 0.35f) {
            float damage = speed * 10.0f;
            entityIn.func_70097_a((DamageSource)DamageSourceCar.DAMAGE_CAR, damage);
        }
        return super.func_70114_g(entityIn);
    }

    private void handleTeleport() {
        if (!Config.teleportDimension) {
            return;
        }
        if (this.getSpeed() >= this.maxSpeed) {
            int dimid = this.field_70170_p.field_73011_w.getDimension();
            if (dimid == Config.teleportDimID) {
                return;
            }
            for (Entity e : this.func_184188_bt()) {
                e.func_184210_p();
                Teleport.teleportToDimension(e, Config.teleportDimID);
            }
            Teleport.teleportToDimension(this, Config.teleportDimID);
        }
    }

    public void checkPush() {
        if (this.func_70046_E() == null) {
            return;
        }
        List list = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_70046_E().func_72321_a(0.2, 0.0, 0.2).func_72321_a(-0.2, 0.0, -0.2), EntitySelectors.func_188442_a((Entity)this));
        for (int j = 0; j < list.size(); ++j) {
            EntityPlayer player = (EntityPlayer)list.get(j);
            if (player.func_184196_w((Entity)this) || !player.func_70093_af()) continue;
            double motX = EntityCarBase.calculateMotionX(0.05f, player.field_70177_z);
            double motZ = EntityCarBase.calculateMotionZ(0.05f, player.field_70177_z);
            this.func_70091_d(MoverType.PLAYER, motX, 0.0, motZ);
            return;
        }
    }

    public boolean canEngineStayOn() {
        return !this.func_70090_H() && !this.func_180799_ab();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSounds() {
        if (this.getSpeed() == 0.0f && this.isStarted()) {
            if (!this.startedLast) {
                this.checkStartLoop();
            } else if (!this.isSoundPlaying((ISound)this.startLoop)) {
                if (this.startLoop != null) {
                    this.startLoop.setDonePlaying();
                    this.startLoop = null;
                }
                this.checkIdleLoop();
            }
        }
        if (this.getSpeed() != 0.0f && this.isStarted()) {
            this.checkHighLoop();
        }
        this.startedLast = this.isStarted();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSoundPlaying(ISound sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.func_71410_x().func_147118_V().func_147692_c(sound);
    }

    public void destroyCar(EntityPlayer player, boolean dropParts) {
        this.func_70106_y();
    }

    public boolean shouldDropItemWithChance(ItemStack stack) {
        return this.field_70146_Z.nextInt(10) != 0;
    }

    public abstract ICarbuilder getBuilder();

    private void controlCar() {
        if (!this.func_184207_aI()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        float modifier = 1.0f;
        if (Config.carGroundSpeed) {
            modifier = this.getModifier();
        }
        float maxSp = this.maxSpeed * modifier;
        float maxBackSp = this.maxReverseSpeed * modifier;
        float speed = MathTools.subtractToZero(this.getSpeed(), this.rollResistance);
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.acceleration, maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.acceleration, -maxBackSp);
        }
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = MathHelper.func_76135_e((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = MathHelper.func_76131_a((float)rotationSpeed, (float)this.minRotationSpeed, (float)this.maxRotationSpeed);
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.field_70177_z += this.deltaRotation;
        if (this.field_70177_z > 180.0f) {
            this.field_70177_z -= 360.0f;
            this.field_70126_B = this.field_70177_z;
        } else if (this.field_70177_z <= -180.0f) {
            this.field_70177_z += 360.0f;
            this.field_70126_B = this.field_70177_z;
        }
        if (this.field_70123_F) {
            if (this.field_70170_p.field_72995_K && !this.collidedLastTick) {
                this.onCollision(speed);
                this.collidedLastTick = true;
            }
        } else {
            this.field_70159_w = EntityCarBase.calculateMotionX(this.getSpeed(), this.field_70177_z);
            this.field_70179_y = EntityCarBase.calculateMotionZ(this.getSpeed(), this.field_70177_z);
            if (this.field_70170_p.field_72995_K) {
                this.collidedLastTick = false;
            }
        }
    }

    public float getModifier() {
        BlockPos pos = this.func_180425_c().func_177977_b();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b.equals(Blocks.field_150350_a)) {
            return 1.0f;
        }
        if (Config.isDrivable(b)) {
            return 1.0f;
        }
        return 0.5f;
    }

    public abstract float getRotationModifier();

    public void onCollision(float speed) {
        if (this.field_70170_p.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageCrash(speed, this));
        }
        this.setSpeed(0.01f);
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean canPlayerDriveCar(EntityPlayer player) {
        if (player.equals((Object)this.getDriver()) && this.isStarted()) {
            return true;
        }
        if (this.func_70090_H() || this.func_180799_ab()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.func_189652_ae()) {
            this.field_70181_x = 0.0;
            return;
        }
        this.field_70181_x += -0.2;
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, EntityPlayer player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.field_70170_p.field_72995_K && needsUpdate) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageControlCar(forward, backward, left, right, player));
        }
    }

    public void startCarEngine() {
        EntityPlayer player = this.getDriver();
        if (player != null && this.canStartCarEngine(player)) {
            this.setStarted(true);
        }
    }

    public boolean canStartCarEngine(EntityPlayer player) {
        return !this.func_70090_H() && !this.func_180799_ab();
    }

    @Override
    public double func_70042_X() {
        return -0.4;
    }

    public boolean canPlayerEnterCar(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.canPlayerEnterCar(player)) {
            return false;
        }
        return super.func_184230_a(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float updateWheelRotation(float delta) {
        this.wheelRotation += delta * this.getSpeed() * 8.0f;
        return this.wheelRotation;
    }

    public void openCarGUi(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageCarGui(true, player));
        }
    }

    public boolean isAccelerating() {
        boolean b = (this.isForward() || this.isBackward()) && !this.field_70123_F;
        return b && this.isStarted();
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STARTED, (Object)false);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FORWARD, (Object)false);
        this.field_70180_af.func_187214_a(BACKWARD, (Object)false);
        this.field_70180_af.func_187214_a(LEFT, (Object)false);
        this.field_70180_af.func_187214_a(RIGHT, (Object)false);
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
    }

    public void setStarted(boolean started) {
        this.setStarted(started, true, false);
    }

    public void setStarted(boolean started, boolean playStopSound, boolean playFailSound) {
        if (!started && playStopSound) {
            this.playStopSound();
        } else if (!started && playFailSound) {
            this.playFailSound();
        }
        if (started) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        this.field_70180_af.func_187227_b(STARTED, (Object)started);
    }

    public boolean isStarted() {
        return (Boolean)this.field_70180_af.func_187225_a(STARTED);
    }

    public void setForward(boolean forward) {
        this.field_70180_af.func_187227_b(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.field_70180_af.func_187227_b(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.field_70180_af.func_187227_b(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.field_70180_af.func_187225_a(LEFT);
    }

    public void setRight(boolean right) {
        this.field_70180_af.func_187227_b(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.field_70180_af.func_187225_a(RIGHT);
    }

    public abstract ITextComponent getCarName();

    protected void func_70037_a(NBTTagCompound compound) {
        this.setStarted(compound.func_74767_n("started"), false, false);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("started", this.isStarted());
    }

    public void playStopSound() {
        ModSounds.playSound(this.getStopSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playCrashSound() {
        ModSounds.playSound(this.getCrashSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public void playHornSound() {
        ModSounds.playSound(this.getHornSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.NEUTRAL, Config.carVolume);
    }

    public SoundEvent getStopSound() {
        return ModSounds.engine_stop;
    }

    public SoundEvent getFailSound() {
        return ModSounds.engine_fail;
    }

    public SoundEvent getCrashSound() {
        return ModSounds.car_crash;
    }

    public SoundEvent getStartSound() {
        return ModSounds.engine_start;
    }

    public SoundEvent getStartingSound() {
        return ModSounds.engine_starting;
    }

    public SoundEvent getIdleSound() {
        return ModSounds.engine_idle;
    }

    public SoundEvent getHighSound() {
        return ModSounds.engine_high;
    }

    public SoundEvent getHornSound() {
        return ModSounds.car_horn;
    }

    @SideOnly(value=Side.CLIENT)
    public void checkIdleLoop() {
        if (!this.isSoundPlaying((ISound)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this.field_70170_p, this, this.getIdleSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.idleLoop, this.field_70170_p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void checkHighLoop() {
        if (!this.isSoundPlaying((ISound)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this.field_70170_p, this, this.getHighSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.highLoop, this.field_70170_p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void checkStartLoop() {
        if (!this.isSoundPlaying((ISound)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this.field_70170_p, this, this.getStartSound(), SoundCategory.NEUTRAL);
            ModSounds.playSoundLoop(this.startLoop, this.field_70170_p);
        }
    }

    public void onHornPressed(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageCarHorn(true, player));
        } else {
            if (this instanceof EntityCarBatteryBase) {
                EntityCarBatteryBase car = (EntityCarBatteryBase)this;
                if (car.getBatteryLevel() < 10) {
                    return;
                }
                if (Config.useBattery) {
                    car.setBatteryLevel(car.getBatteryLevel() - 10);
                }
            }
            this.playHornSound();
            if (Config.hornFlee) {
                double radius = 15.0;
                List list = this.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius));
                for (EntityLiving ent : list) {
                    this.fleeEntity(ent);
                }
            }
        }
    }

    public void fleeEntity(EntityLiving entity) {
        double fleeDistance = 10.0;
        Vec3d vecCar = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vecEntity = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vec3d fleeDir = vecEntity.func_178788_d(vecCar);
        fleeDir = fleeDir.func_72432_b();
        Vec3d fleePos = new Vec3d(vecEntity.field_72450_a + fleeDir.field_72450_a * fleeDistance, vecEntity.field_72448_b + fleeDir.field_72448_b * fleeDistance, vecEntity.field_72449_c + fleeDir.field_72449_c * fleeDistance);
        entity.func_70661_as().func_75492_a(fleePos.field_72450_a, fleePos.field_72448_b, fleePos.field_72449_c, 2.5);
    }
}

