/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.ModCreativeTabs;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemCanister
extends Item {
    private static int maxFuel;

    public ItemCanister() {
        this.func_77625_d(1);
        this.func_77655_b("canister");
        this.setRegistryName("canister");
        this.func_77637_a(ModCreativeTabs.TAB_CAR);
        maxFuel = Config.canisterMaxFuel;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity te = null;
        te = state.func_177230_c().equals((Object)ModBlocks.FUEL_STATION_TOP) ? worldIn.func_175625_s(pos.func_177977_b()) : worldIn.func_175625_s(pos);
        if (te == null) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (te instanceof TileEntityFuelStation) {
            TileEntityFuelStation fuel = (TileEntityFuelStation)te;
            boolean success = ItemCanister.fillCanister(player.func_184586_b(hand), fuel);
            if (success) {
                ModSounds.playSound(SoundEvents.field_187621_J, worldIn, pos, null, SoundCategory.BLOCKS);
            }
            return EnumActionResult.SUCCESS;
        }
        if (te instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)te;
            boolean success = ItemCanister.fuelFluidHandler(player.func_184586_b(hand), handler);
            if (success) {
                ModSounds.playSound(SoundEvents.field_187621_J, worldIn, pos, null, SoundCategory.BLOCKS);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound comp = stack.func_77978_p();
            if (comp.func_74764_b("fuel")) {
                NBTTagCompound fuel = comp.func_74775_l("fuel");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fuel);
                if (fluidStack == null) {
                    this.addInfo("-", 0, tooltip);
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                    return;
                }
                this.addInfo(fluidStack.getLocalizedName(), fluidStack.amount, tooltip);
                super.func_77624_a(stack, worldIn, tooltip, flagIn);
                return;
            }
            this.addInfo("-", 0, tooltip);
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            return;
        }
        this.addInfo("-", 0, tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private void addInfo(String fluid, int amount, List<String> tooltip) {
        tooltip.add(new TextComponentTranslation("canister.fluid", new Object[]{fluid}).func_150254_d());
        tooltip.add(new TextComponentTranslation("canister.amount", new Object[]{amount}).func_150254_d());
    }

    public static boolean fillCanister(ItemStack canister, IFluidHandler handler) {
        FluidStack resultSim;
        if (!canister.func_77942_o()) {
            canister.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound comp = canister.func_77978_p();
        FluidStack fluid = null;
        if (comp.func_74764_b("fuel")) {
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)comp.func_74775_l("fuel"));
        }
        int maxAmount = maxFuel;
        if (fluid != null) {
            maxAmount = maxFuel - fluid.amount;
        }
        if (maxAmount <= 0) {
            return false;
        }
        if (!(fluid == null || (resultSim = handler.drain(maxAmount, false)) != null && resultSim.getFluid().equals(fluid.getFluid()))) {
            return false;
        }
        FluidStack result = handler.drain(maxAmount, true);
        if (result == null) {
            return false;
        }
        if (fluid == null) {
            comp.func_74782_a("fuel", (NBTBase)result.writeToNBT(new NBTTagCompound()));
            return true;
        }
        if (result.getFluid().equals(fluid.getFluid())) {
            fluid.amount += result.amount;
            comp.func_74782_a("fuel", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
        }
        return true;
    }

    public static boolean fuelFluidHandler(ItemStack canister, IFluidHandler handler) {
        if (!canister.func_77942_o()) {
            return false;
        }
        NBTTagCompound comp = canister.func_77978_p();
        if (!comp.func_74764_b("fuel")) {
            return false;
        }
        NBTTagCompound fluid = comp.func_74775_l("fuel");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluid);
        if (stack == null) {
            return false;
        }
        int fueledAmount = handler.fill(stack, true);
        stack.amount -= fueledAmount;
        if (stack.amount <= 0) {
            comp.func_74782_a("fuel", (NBTBase)new NBTTagCompound());
            return true;
        }
        NBTTagCompound f = new NBTTagCompound();
        stack.writeToNBT(f);
        comp.func_74782_a("fuel", (NBTBase)f);
        return true;
    }
}

