/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.net.MessageToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class MessageStarting
extends MessageToServer<MessageStarting> {
    private boolean start;
    private boolean playSound;
    private UUID uuid;

    public MessageStarting() {
        this.start = true;
        this.uuid = new UUID(0L, 0L);
    }

    public MessageStarting(boolean start, boolean playSound, EntityPlayer player) {
        this.start = start;
        this.playSound = playSound;
        this.uuid = player.func_110124_au();
    }

    @Override
    public void execute(EntityPlayer player, MessageStarting message) {
        if (!player.func_110124_au().equals(message.uuid)) {
            System.out.println("---------UUID was not the same-----------");
            return;
        }
        Entity riding = player.func_184187_bx();
        if (!(riding instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)riding;
        if (player.equals((Object)car.getDriver())) {
            car.setStarting(message.start, message.playSound);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.start = buf.readBoolean();
        this.playSound = buf.readBoolean();
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.uuid = new UUID(l1, l2);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.start);
        buf.writeBoolean(this.playSound);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }
}

