/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.fluids.ModFluids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static ForgeConfigSpec.IntValue backmixReactorEnergyStorage;
    public static ForgeConfigSpec.IntValue backmixReactorEnergyUsage;
    public static ForgeConfigSpec.IntValue backmixReactorFluidStorage;
    public static ForgeConfigSpec.IntValue backmixReactorGeneratingTime;
    public static ForgeConfigSpec.IntValue backmixReactorMixGeneration;
    public static ForgeConfigSpec.IntValue backmixReactorMethanolUsage;
    public static ForgeConfigSpec.IntValue backmixReactorCanolaUsage;
    public static ForgeConfigSpec.IntValue blastFurnaceEnergyStorage;
    public static ForgeConfigSpec.IntValue blastFurnaceGeneratingTime;
    public static ForgeConfigSpec.IntValue blastFurnaceFluidStorage;
    public static ForgeConfigSpec.IntValue blastFurnaceEnergyUsage;
    public static ForgeConfigSpec.IntValue blastFurnaceFluidGeneration;
    public static ForgeConfigSpec.IntValue oilMillEnergyStorage;
    public static ForgeConfigSpec.IntValue oilMillGeneratingTime;
    public static ForgeConfigSpec.IntValue oilMillFluidStorage;
    public static ForgeConfigSpec.IntValue oilMillEnergyUsage;
    public static ForgeConfigSpec.IntValue oilMillFluidGeneration;
    public static ForgeConfigSpec.IntValue cableTransferRate;
    public static ForgeConfigSpec.IntValue dynamoEnergyStorage;
    public static ForgeConfigSpec.IntValue dynamoEnergyGeneration;
    public static ForgeConfigSpec.IntValue fluidExtractorDrainSpeed;
    public static ForgeConfigSpec.IntValue fuelStationTransferRate;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> fuelStationValidFuels;
    public static ForgeConfigSpec.IntValue generatorEnergyStorage;
    public static ForgeConfigSpec.IntValue generatorFluidStorage;
    public static ForgeConfigSpec.IntValue generatorEnergyGeneration;
    public static ForgeConfigSpec.IntValue splitTankFluidStorage;
    public static ForgeConfigSpec.IntValue splitTankGeneratingTime;
    public static ForgeConfigSpec.IntValue splitTankMixUsage;
    public static ForgeConfigSpec.IntValue splitTankGlycerinGeneration;
    public static ForgeConfigSpec.IntValue splitTankBioDieselGeneration;
    public static ForgeConfigSpec.DoubleValue repairKitRepairAmount;
    public static ForgeConfigSpec.IntValue canisterMaxFuel;
    public static ForgeConfigSpec.DoubleValue carVolume;
    public static ForgeConfigSpec.BooleanValue thirdPersonEnter;
    public static ForgeConfigSpec.BooleanValue carGroundSpeed;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> carDriveBlocks;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> carValidFuels;
    public static ForgeConfigSpec.BooleanValue collideWithEntities;
    public static ForgeConfigSpec.BooleanValue damageEntities;
    public static ForgeConfigSpec.BooleanValue hornFlee;
    public static ForgeConfigSpec.BooleanValue useBattery;
    public static ForgeConfigSpec.BooleanValue tempInFarenheit;
    public static float engine6CylinderFuelEfficiency;
    public static float engine3CylinderFuelEfficiency;
    public static float engineTruckFuelEfficiency;
    public static float engine6CylinderAcceleration;
    public static float engine3CylinderAcceleration;
    public static float engineTruckAcceleration;
    public static float engine6CylinderMaxSpeed;
    public static float engine3CylinderMaxSpeed;
    public static float engineTruckMaxSpeed;
    public static float engine6CylinderMaxReverseSpeed;
    public static float engine3CylinderMaxReverseSpeed;
    public static float engineTruckMaxReverseSpeed;
    public static float bodyBigWoodFuelEfficiency;
    public static float bodyBigWoodAcceleration;
    public static float bodyBigWoodMaxSpeed;
    public static float bodyWoodFuelEfficiency;
    public static float bodyWoodAcceleration;
    public static float bodyWoodMaxSpeed;
    public static float bodySportFuelEfficiency;
    public static float bodySportAcceleration;
    public static float bodySportMaxSpeed;
    public static float bodySUVFuelEfficiency;
    public static float bodySUVAcceleration;
    public static float bodySUVMaxSpeed;
    public static float bodyTransporterFuelEfficiency;
    public static float bodyTransporterAcceleration;
    public static float bodyTransporterMaxSpeed;
    public static List<Fluid> fuelStationValidFuelList;
    public static List<Block> carDriveBlockList;
    public static List<Fluid> carValidFuelList;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void loadServer() {
        fuelStationValidFuelList = ((List)fuelStationValidFuels.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        carDriveBlockList = ((List)carDriveBlocks.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        carValidFuelList = ((List)carValidFuels.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void loadClient() {
    }

    static {
        engine6CylinderFuelEfficiency = 0.25f;
        engine3CylinderFuelEfficiency = 0.5f;
        engineTruckFuelEfficiency = 0.7f;
        engine6CylinderAcceleration = 0.04f;
        engine3CylinderAcceleration = 0.035f;
        engineTruckAcceleration = 0.032f;
        engine6CylinderMaxSpeed = 0.75f;
        engine3CylinderMaxSpeed = 0.65f;
        engineTruckMaxSpeed = 0.6f;
        engine6CylinderMaxReverseSpeed = 0.2f;
        engine3CylinderMaxReverseSpeed = 0.2f;
        engineTruckMaxReverseSpeed = 0.15f;
        bodyBigWoodFuelEfficiency = 0.7f;
        bodyBigWoodAcceleration = 0.95f;
        bodyBigWoodMaxSpeed = 0.85f;
        bodyWoodFuelEfficiency = 0.8f;
        bodyWoodAcceleration = 1.0f;
        bodyWoodMaxSpeed = 0.9f;
        bodySportFuelEfficiency = 0.9f;
        bodySportAcceleration = 1.0f;
        bodySportMaxSpeed = 1.0f;
        bodySUVFuelEfficiency = 0.6f;
        bodySUVAcceleration = 0.8f;
        bodySUVMaxSpeed = 0.7f;
        bodyTransporterFuelEfficiency = 0.6f;
        bodyTransporterAcceleration = 0.8f;
        bodyTransporterMaxSpeed = 0.765f;
        fuelStationValidFuelList = new ArrayList<Fluid>();
        carDriveBlockList = new ArrayList<Block>();
        carValidFuelList = new ArrayList<Fluid>();
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            thirdPersonEnter = builder.define("car.third_person_when_enter_car", true);
            tempInFarenheit = builder.comment("True if the car temperature should be displayed in farenheit").define("car.temp_farenheit", false);
            carVolume = builder.defineInRange("car.car_volume", 0.25, 0.0, 1.0);
        }
    }

    public static class ServerConfig {
        public ServerConfig(ForgeConfigSpec.Builder builder) {
            backmixReactorEnergyStorage = builder.defineInRange("machines.backmix_reactor.energy_storage", 10000, 100, Short.MAX_VALUE);
            backmixReactorEnergyUsage = builder.defineInRange("machines.backmix_reactor.energy_usage", 10, 1, Short.MAX_VALUE);
            backmixReactorFluidStorage = builder.defineInRange("machines.backmix_reactor.fluid_storage", 3000, 1000, Short.MAX_VALUE);
            backmixReactorGeneratingTime = builder.defineInRange("machines.backmix_reactor.generating_time", 200, 10, Short.MAX_VALUE);
            backmixReactorMixGeneration = builder.defineInRange("machines.backmix_reactor.mix_generation", 100, 1, Short.MAX_VALUE);
            backmixReactorMethanolUsage = builder.defineInRange("machines.backmix_reactor.methanol_usage", 50, 1, Short.MAX_VALUE);
            backmixReactorCanolaUsage = builder.defineInRange("machines.backmix_reactor.canola_usage", 50, 1, Short.MAX_VALUE);
            blastFurnaceEnergyStorage = builder.defineInRange("machines.blast_furnace.energy_storage", 10000, 1000, Short.MAX_VALUE);
            blastFurnaceGeneratingTime = builder.defineInRange("machines.blast_furnace.generating_time", 200, 10, Short.MAX_VALUE);
            blastFurnaceFluidStorage = builder.defineInRange("machines.blast_furnace.fluid_storage", 3000, 1000, Short.MAX_VALUE);
            blastFurnaceEnergyUsage = builder.defineInRange("machines.blast_furnace.energy_usage", 10, 1, Short.MAX_VALUE);
            blastFurnaceFluidGeneration = builder.defineInRange("machines.blast_furnace.fluid_generation", 100, 1, Short.MAX_VALUE);
            oilMillEnergyStorage = builder.defineInRange("machines.oil_mill.energy_storage", 10000, 1000, Short.MAX_VALUE);
            oilMillGeneratingTime = builder.defineInRange("machines.oil_mill.generating_time", 200, 10, Short.MAX_VALUE);
            oilMillFluidStorage = builder.defineInRange("machines.oil_mill.fluid_storage", 3000, 1000, Short.MAX_VALUE);
            oilMillEnergyUsage = builder.defineInRange("machines.oil_mill.energy_usage", 10, 1, Short.MAX_VALUE);
            oilMillFluidGeneration = builder.defineInRange("machines.oil_mill.fluid_generation", 100, 1, Short.MAX_VALUE);
            cableTransferRate = builder.defineInRange("machines.cable.transfer_rate", 256, 64, Short.MAX_VALUE);
            dynamoEnergyStorage = builder.defineInRange("machines.dynamo.energy_storage", 1000, 100, Short.MAX_VALUE);
            dynamoEnergyGeneration = builder.defineInRange("machines.dynamo.energy_generation", 25, 1, Short.MAX_VALUE);
            fluidExtractorDrainSpeed = builder.defineInRange("machines.fluid_extractor.drain_speed", 25, 5, Short.MAX_VALUE);
            fuelStationTransferRate = builder.defineInRange("machines.fuel_station.transfer_rate", 5, 1, Short.MAX_VALUE);
            fuelStationValidFuels = builder.defineList("machines.fuel_station.valid_fuels", Arrays.asList(ModFluids.BIO_DIESEL.getRegistryName().toString()), Objects::nonNull);
            generatorEnergyStorage = builder.defineInRange("machines.generator.energy_storage", 30000, 1000, Short.MAX_VALUE);
            generatorFluidStorage = builder.defineInRange("machines.generator.fluid_storage", 3000, 1000, Short.MAX_VALUE);
            generatorEnergyGeneration = builder.defineInRange("machines.generator.energy_generation", 500, 1, Short.MAX_VALUE);
            splitTankFluidStorage = builder.defineInRange("machines.split_tank.fluid_storage", 3000, 1000, Short.MAX_VALUE);
            splitTankGeneratingTime = builder.defineInRange("machines.split_tank.generating_time", 800, 10, Short.MAX_VALUE);
            splitTankMixUsage = builder.defineInRange("machines.split_tank.mix_usage", 100, 1, Short.MAX_VALUE);
            splitTankGlycerinGeneration = builder.defineInRange("machines.split_tank.glycerin_generation", 10, 1, Short.MAX_VALUE);
            splitTankBioDieselGeneration = builder.defineInRange("machines.split_tank.bio_diesel_generation", 100, 1, Short.MAX_VALUE);
            repairKitRepairAmount = builder.defineInRange("items.repair_kit.repair_amount", 5.0, (double)0.1f, 100.0);
            canisterMaxFuel = builder.defineInRange("items.canister.max_fuel", 100, 1, 1000);
            collideWithEntities = builder.comment("Whether the cars should collide with other entities (except cars)").define("car.collide_with_entities", false);
            damageEntities = builder.comment("Whether the cars should damage other entities on collision").define("car.damage_entities", true);
            hornFlee = builder.comment("Whether animals flee from the car when the horn is activted").define("car.horn_flee", true);
            useBattery = builder.comment("True if starting the car should use battery").define("car.use_battery", true);
            carGroundSpeed = builder.comment("Whether the cars drive slower on non road blocks").define("car.road_blocks_enabled", false);
            carDriveBlocks = builder.defineList("car.road_blocks.blocks", Arrays.asList(ModBlocks.ASPHALT.getRegistryName().toString(), ModBlocks.ASPHALT_SLAB.getRegistryName().toString(), ModBlocks.ASPHALT_SLOPE.getRegistryName().toString(), ModBlocks.ASPHALT_SLOPE_FLAT_LOWER.getRegistryName().toString(), ModBlocks.ASPHALT_SLOPE_FLAT_UPPER.getRegistryName().toString()), Objects::nonNull);
            carValidFuels = builder.defineList("car.valid_fuels", Arrays.asList(ModFluids.BIO_DIESEL.getRegistryName().toString()), Objects::nonNull);
        }
    }
}

