/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.blocks.tileentity.TileEntityBlastFurnace;
import de.maxhenkel.car.blocks.tileentity.TileEntityCable;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.blocks.tileentity.TileEntityDynamo;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.blocks.tileentity.TileEntityOilMill;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSign;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSplitTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererTank;
import de.maxhenkel.car.blocks.tileentity.render.TileentitySpecialRendererFuelStation;
import de.maxhenkel.car.commands.CommandCarDemo;
import de.maxhenkel.car.dataserializers.DataSerializerItemList;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.model.GenericCarModel;
import de.maxhenkel.car.events.BlockEvents;
import de.maxhenkel.car.events.CapabilityEvents;
import de.maxhenkel.car.events.KeyEvents;
import de.maxhenkel.car.events.PlayerEvents;
import de.maxhenkel.car.events.RenderEvents;
import de.maxhenkel.car.events.SoundEvents;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import de.maxhenkel.car.gui.ContainerBlastFurnace;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.gui.ContainerFactoryTileEntity;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.ContainerFuelStation;
import de.maxhenkel.car.gui.ContainerFuelStationAdmin;
import de.maxhenkel.car.gui.ContainerGenerator;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.gui.ContainerOilMill;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.gui.ContainerSplitTank;
import de.maxhenkel.car.gui.GuiBackmixReactor;
import de.maxhenkel.car.gui.GuiBlastFurnace;
import de.maxhenkel.car.gui.GuiCar;
import de.maxhenkel.car.gui.GuiCarInventory;
import de.maxhenkel.car.gui.GuiCarWorkshopCrafting;
import de.maxhenkel.car.gui.GuiCarWorkshopRepair;
import de.maxhenkel.car.gui.GuiFluidExtractor;
import de.maxhenkel.car.gui.GuiFuelStation;
import de.maxhenkel.car.gui.GuiFuelStationAdmin;
import de.maxhenkel.car.gui.GuiGenerator;
import de.maxhenkel.car.gui.GuiLicensePlate;
import de.maxhenkel.car.gui.GuiOilMill;
import de.maxhenkel.car.gui.GuiPainter;
import de.maxhenkel.car.gui.GuiSign;
import de.maxhenkel.car.gui.GuiSplitTank;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.loottable.CopyFluid;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageCenterCarClient;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.net.MessageEditLicensePlate;
import de.maxhenkel.car.net.MessageEditSign;
import de.maxhenkel.car.net.MessageFuelStationAdminAmount;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessagePlaySoundLoop;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.net.MessageStarting;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import de.maxhenkel.car.recipes.ReciepeKey;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.villagers.ModPointsOfInterests;
import de.maxhenkel.car.villagers.ModVillagerProfessions;
import de.maxhenkel.car.villagers.VillagerEvents;
import de.maxhenkel.tools.EntityTools;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="car")
public class Main {
    public static final String MODID = "car";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType CAR_ENTITY_TYPE;
    public static KeyBinding FORWARD_KEY;
    public static KeyBinding BACK_KEY;
    public static KeyBinding LEFT_KEY;
    public static KeyBinding RIGHT_KEY;
    public static KeyBinding CAR_GUI_KEY;
    public static KeyBinding START_KEY;
    public static KeyBinding HORN_KEY;
    public static KeyBinding CENTER_KEY;
    public static ContainerType<ContainerBackmixReactor> BACKMIX_REACTOR_CONTAINER_TYPE;
    public static ContainerType<ContainerBlastFurnace> BLAST_FURNACE_CONTAINER_TYPE;
    public static ContainerType<ContainerCar> CAR_CONTAINER_TYPE;
    public static ContainerType<ContainerCarInventory> CAR_INVENTORY_CONTAINER_TYPE;
    public static ContainerType<ContainerCarWorkshopCrafting> CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE;
    public static ContainerType<ContainerCarWorkshopRepair> CAR_WORKSHOP_REPAIR_CONTAINER_TYPE;
    public static ContainerType<ContainerFluidExtractor> FLUID_EXTRACTOR_CONTAINER_TYPE;
    public static ContainerType<ContainerFuelStation> FUEL_STATION_CONTAINER_TYPE;
    public static ContainerType<ContainerFuelStationAdmin> FUEL_STATION_ADMIN_CONTAINER_TYPE;
    public static ContainerType<ContainerGenerator> GENERATOR_CONTAINER_TYPE;
    public static ContainerType<ContainerLicensePlate> LICENSE_PLATE_CONTAINER_TYPE;
    public static ContainerType<ContainerOilMill> OIL_MILL_CONTAINER_TYPE;
    public static ContainerType<ContainerPainter> PAINTER_CONTAINER_TYPE;
    public static ContainerType<ContainerSign> SIGN_CONTAINER_TYPE;
    public static ContainerType<ContainerSplitTank> SPLIT_TANK_CONTAINER_TYPE;
    public static TileEntityType GENERATOR_TILE_ENTITY_TYPE;
    public static TileEntityType BACKMIX_REACTOR_TILE_ENTITY_TYPE;
    public static TileEntityType BLAST_FURNACE_TILE_ENTITY_TYPE;
    public static TileEntityType CABLE_TILE_ENTITY_TYPE;
    public static TileEntityType CAR_WORKSHOP_TILE_ENTITY_TYPE;
    public static TileEntityType DYNAMO_TILE_ENTITY_TYPE;
    public static TileEntityType FLUID_EXTRACTOR_TILE_ENTITY_TYPE;
    public static TileEntityType OIL_MILL_TILE_ENTITY_TYPE;
    public static TileEntityType SIGN_TILE_ENTITY_TYPE;
    public static TileEntityType SPLIT_TANK_TILE_ENTITY_TYPE;
    public static TileEntityType TANK_TILE_ENTITY_TYPE;
    public static TileEntityType FUEL_STATION_TILE_ENTITY_TYPE;
    public static IRecipeSerializer CRAFTING_SPECIAL_KEY;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(DataSerializerEntry.class, this::registerSerializers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Fluid.class, this::registerFluids);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(PointOfInterestType.class, this::registerPointsOfInterest);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(VillagerProfession.class, this::registerVillagerProfessions);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @SubscribeEvent
    public void configEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.loadServer();
        } else if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.loadClient();
        }
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        CommandCarDemo.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        RenderingRegistry.registerEntityRenderingHandler(EntityGenericCar.class, manager -> new GenericCarModel(manager));
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new VillagerEvents());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new CopyFluid.Serializer());
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "default"), () -> "1.0.0", s -> true, s -> true);
        SIMPLE_CHANNEL.registerMessage(0, MessageControlCar.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageControlCar().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessageCarGui.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageCarGui().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageStarting.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageStarting().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageCrash.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageCrash().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(4, MessageStartFuel.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageStartFuel().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(5, MessagePlaySoundLoop.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessagePlaySoundLoop().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(6, MessageSyncTileEntity.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSyncTileEntity().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(7, MessageSpawnCar.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSpawnCar().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(8, MessageOpenCarWorkshopGui.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageOpenCarWorkshopGui().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(9, MessageRepairCar.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageRepairCar().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(10, MessageCarHorn.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageCarHorn().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(11, MessageEditSign.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageEditSign().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(12, MessageFuelStationAdminAmount.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageFuelStationAdminAmount().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(13, MessageCenterCar.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageCenterCar().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(14, MessageCenterCarClient.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageCenterCarClient().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(15, MessageEditLicensePlate.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageEditLicensePlate().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFuelStation.class, (TileEntityRenderer)new TileentitySpecialRendererFuelStation());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySplitTank.class, (TileEntityRenderer)new TileEntitySpecialRendererSplitTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTank.class, (TileEntityRenderer)new TileEntitySpecialRendererTank());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySign.class, (TileEntityRenderer)new TileEntitySpecialRendererSign());
        ScreenManager.IScreenFactory factory1 = GuiBackmixReactor::new;
        ScreenManager.func_216911_a(BACKMIX_REACTOR_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory1);
        ScreenManager.IScreenFactory factory2 = GuiBlastFurnace::new;
        ScreenManager.func_216911_a(BLAST_FURNACE_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory2);
        ScreenManager.IScreenFactory factory3 = GuiCar::new;
        ScreenManager.func_216911_a(CAR_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory3);
        ScreenManager.IScreenFactory factory15 = GuiCarInventory::new;
        ScreenManager.func_216911_a(CAR_INVENTORY_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory15);
        ScreenManager.IScreenFactory factory4 = GuiCarWorkshopCrafting::new;
        ScreenManager.func_216911_a(CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory4);
        ScreenManager.IScreenFactory factory5 = GuiCarWorkshopRepair::new;
        ScreenManager.func_216911_a(CAR_WORKSHOP_REPAIR_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory5);
        ScreenManager.IScreenFactory factory6 = GuiFluidExtractor::new;
        ScreenManager.func_216911_a(FLUID_EXTRACTOR_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory6);
        ScreenManager.IScreenFactory factory7 = GuiFuelStation::new;
        ScreenManager.func_216911_a(FUEL_STATION_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory7);
        ScreenManager.IScreenFactory factory8 = (container, playerInventory, name) -> new GuiFuelStationAdmin((ContainerFuelStationAdmin)container, playerInventory, name);
        ScreenManager.func_216911_a(FUEL_STATION_ADMIN_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory8);
        ScreenManager.IScreenFactory factory9 = (container, playerInventory, name) -> new GuiGenerator((ContainerGenerator)container, playerInventory, name);
        ScreenManager.func_216911_a(GENERATOR_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory9);
        ScreenManager.IScreenFactory factory10 = (container, playerInventory, name) -> new GuiLicensePlate((ContainerLicensePlate)container, playerInventory, name);
        ScreenManager.func_216911_a(LICENSE_PLATE_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory10);
        ScreenManager.IScreenFactory factory11 = (container, playerInventory, name) -> new GuiOilMill((ContainerOilMill)container, playerInventory, name);
        ScreenManager.func_216911_a(OIL_MILL_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory11);
        ScreenManager.IScreenFactory factory12 = (container, playerInventory, name) -> new GuiPainter((ContainerPainter)container, playerInventory, name);
        ScreenManager.func_216911_a(PAINTER_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory12);
        ScreenManager.IScreenFactory factory13 = (container, playerInventory, name) -> new GuiSign((ContainerSign)container, name);
        ScreenManager.func_216911_a(SIGN_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory13);
        ScreenManager.IScreenFactory factory14 = (container, playerInventory, name) -> new GuiSplitTank((ContainerSplitTank)container, playerInventory, name);
        ScreenManager.func_216911_a(SPLIT_TANK_CONTAINER_TYPE, (ScreenManager.IScreenFactory)factory14);
        FORWARD_KEY = new KeyBinding("key.car_forward", 87, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)FORWARD_KEY);
        BACK_KEY = new KeyBinding("key.car_back", 83, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)BACK_KEY);
        LEFT_KEY = new KeyBinding("key.car_left", 65, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)LEFT_KEY);
        RIGHT_KEY = new KeyBinding("key.car_right", 68, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)RIGHT_KEY);
        CAR_GUI_KEY = new KeyBinding("key.car_gui", 73, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)CAR_GUI_KEY);
        START_KEY = new KeyBinding("key.car_start", 82, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)START_KEY);
        HORN_KEY = new KeyBinding("key.car_horn", 72, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)HORN_KEY);
        CENTER_KEY = new KeyBinding("key.center_car", 32, "category.car");
        ClientRegistry.registerKeyBinding((KeyBinding)CENTER_KEY);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SoundEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.getBlocksWithItems().stream().map(block -> block.toItem()).toArray(Item[]::new));
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.getAll().toArray(new Item[0]));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.getAll().toArray(new Block[0]));
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.getAll().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        CAR_ENTITY_TYPE = EntityType.Builder.func_220322_a(EntityGenericCar::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(128).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new EntityGenericCar((World)world)).func_206830_a("car:car");
        CAR_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register((IForgeRegistryEntry)CAR_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        BACKMIX_REACTOR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerBackmixReactor, TileEntityBackmixReactor>(ContainerBackmixReactor::new));
        BACKMIX_REACTOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "backmix_reactor"));
        event.getRegistry().register(BACKMIX_REACTOR_CONTAINER_TYPE);
        BLAST_FURNACE_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerBlastFurnace, TileEntityBlastFurnace>(ContainerBlastFurnace::new));
        BLAST_FURNACE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(BLAST_FURNACE_CONTAINER_TYPE);
        CAR_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.field_70458_d, data.func_179253_g());
            if (car == null) {
                return null;
            }
            return new ContainerCar(windowId, car, inv);
        }));
        CAR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(CAR_CONTAINER_TYPE);
        CAR_INVENTORY_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.field_70458_d, data.func_179253_g());
            if (car == null) {
                return null;
            }
            return new ContainerCarInventory(windowId, car, inv);
        }));
        CAR_INVENTORY_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_inventory"));
        event.getRegistry().register(CAR_INVENTORY_CONTAINER_TYPE);
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerCarWorkshopCrafting, TileEntityCarWorkshop>(ContainerCarWorkshopCrafting::new));
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop_crafting"));
        event.getRegistry().register(CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE);
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerCarWorkshopRepair, TileEntityCarWorkshop>(ContainerCarWorkshopRepair::new));
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop_repair"));
        event.getRegistry().register(CAR_WORKSHOP_REPAIR_CONTAINER_TYPE);
        FLUID_EXTRACTOR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerFluidExtractor, TileEntityFluidExtractor>(ContainerFluidExtractor::new));
        FLUID_EXTRACTOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fluid_extractor"));
        event.getRegistry().register(FLUID_EXTRACTOR_CONTAINER_TYPE);
        FUEL_STATION_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerFuelStation, TileEntityFuelStation>(ContainerFuelStation::new));
        FUEL_STATION_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station"));
        event.getRegistry().register(FUEL_STATION_CONTAINER_TYPE);
        FUEL_STATION_ADMIN_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerFuelStationAdmin, TileEntityFuelStation>(ContainerFuelStationAdmin::new));
        FUEL_STATION_ADMIN_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station_admin"));
        event.getRegistry().register(FUEL_STATION_ADMIN_CONTAINER_TYPE);
        GENERATOR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerGenerator, TileEntityGenerator>(ContainerGenerator::new));
        GENERATOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "generator"));
        event.getRegistry().register(GENERATOR_CONTAINER_TYPE);
        LICENSE_PLATE_CONTAINER_TYPE = new ContainerType((id, inv) -> {
            ItemStack licensePlate = null;
            for (Hand hand : Hand.values()) {
                ItemStack stack = inv.field_70458_d.func_184586_b(hand);
                if (!(stack.func_77973_b() instanceof ItemLicensePlate)) continue;
                licensePlate = stack;
                break;
            }
            if (licensePlate != null) {
                return new ContainerLicensePlate(id, licensePlate);
            }
            return null;
        });
        LICENSE_PLATE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "license_plate"));
        event.getRegistry().register(LICENSE_PLATE_CONTAINER_TYPE);
        OIL_MILL_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerOilMill, TileEntityOilMill>(ContainerOilMill::new));
        OIL_MILL_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(OIL_MILL_CONTAINER_TYPE);
        PAINTER_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> new ContainerPainter(windowId, inv, data.readBoolean())));
        PAINTER_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "painter"));
        event.getRegistry().register(PAINTER_CONTAINER_TYPE);
        SIGN_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerSign, TileEntitySign>((windowId, tileEntity, inv) -> new ContainerSign(windowId, (TileEntitySign)tileEntity)));
        SIGN_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "sign"));
        event.getRegistry().register(SIGN_CONTAINER_TYPE);
        SPLIT_TANK_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerSplitTank, TileEntitySplitTank>(ContainerSplitTank::new));
        SPLIT_TANK_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "split_tank"));
        event.getRegistry().register(SPLIT_TANK_CONTAINER_TYPE);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        GENERATOR_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityGenerator::new, (Block[])new Block[]{ModBlocks.GENERATOR}).func_206865_a(null);
        GENERATOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "generator"));
        event.getRegistry().register((IForgeRegistryEntry)GENERATOR_TILE_ENTITY_TYPE);
        BACKMIX_REACTOR_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityBackmixReactor::new, (Block[])new Block[]{ModBlocks.BACKMIX_REACTOR}).func_206865_a(null);
        BACKMIX_REACTOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "backmix_reactor"));
        event.getRegistry().register((IForgeRegistryEntry)BACKMIX_REACTOR_TILE_ENTITY_TYPE);
        BLAST_FURNACE_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityBlastFurnace::new, (Block[])new Block[]{ModBlocks.BLAST_FURNACE}).func_206865_a(null);
        BLAST_FURNACE_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register((IForgeRegistryEntry)BLAST_FURNACE_TILE_ENTITY_TYPE);
        CABLE_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityCable::new, (Block[])new Block[]{ModBlocks.CABLE}).func_206865_a(null);
        CABLE_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "cable"));
        event.getRegistry().register((IForgeRegistryEntry)CABLE_TILE_ENTITY_TYPE);
        CAR_WORKSHOP_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityCarWorkshop::new, (Block[])new Block[]{ModBlocks.CAR_WORKSHOP}).func_206865_a(null);
        CAR_WORKSHOP_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop"));
        event.getRegistry().register((IForgeRegistryEntry)CAR_WORKSHOP_TILE_ENTITY_TYPE);
        DYNAMO_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityDynamo::new, (Block[])new Block[]{ModBlocks.DYNAMO}).func_206865_a(null);
        DYNAMO_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "dynamo"));
        event.getRegistry().register((IForgeRegistryEntry)DYNAMO_TILE_ENTITY_TYPE);
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityFluidExtractor::new, (Block[])new Block[]{ModBlocks.FLUID_EXTRACTOR}).func_206865_a(null);
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "fluid_extractor"));
        event.getRegistry().register((IForgeRegistryEntry)FLUID_EXTRACTOR_TILE_ENTITY_TYPE);
        OIL_MILL_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityOilMill::new, (Block[])new Block[]{ModBlocks.OIL_MILL}).func_206865_a(null);
        OIL_MILL_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register((IForgeRegistryEntry)OIL_MILL_TILE_ENTITY_TYPE);
        SIGN_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntitySign::new, (Block[])new Block[]{ModBlocks.SIGN}).func_206865_a(null);
        SIGN_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "sign"));
        event.getRegistry().register((IForgeRegistryEntry)SIGN_TILE_ENTITY_TYPE);
        SPLIT_TANK_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntitySplitTank::new, (Block[])new Block[]{ModBlocks.SPLIT_TANK}).func_206865_a(null);
        SPLIT_TANK_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "split_tank"));
        event.getRegistry().register((IForgeRegistryEntry)SPLIT_TANK_TILE_ENTITY_TYPE);
        TANK_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityTank::new, (Block[])new Block[]{ModBlocks.TANK}).func_206865_a(null);
        TANK_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "tank"));
        event.getRegistry().register((IForgeRegistryEntry)TANK_TILE_ENTITY_TYPE);
        FUEL_STATION_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityFuelStation::new, (Block[])new Block[]{ModBlocks.FUEL_STATION}).func_206865_a(null);
        FUEL_STATION_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station"));
        event.getRegistry().register((IForgeRegistryEntry)FUEL_STATION_TILE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CRAFTING_SPECIAL_KEY = new SpecialRecipeSerializer(ReciepeKey::new);
        CRAFTING_SPECIAL_KEY.setRegistryName(new ResourceLocation(MODID, "crafting_special_key"));
        event.getRegistry().register((IForgeRegistryEntry)CRAFTING_SPECIAL_KEY);
    }

    @SubscribeEvent
    public void registerSerializers(RegistryEvent.Register<DataSerializerEntry> event) {
        DataSerializerEntry dataSerializerEntryItemList = new DataSerializerEntry(DataSerializerItemList.ITEM_LIST);
        dataSerializerEntryItemList.setRegistryName(new ResourceLocation(MODID, "serializer_item_list"));
        event.getRegistry().register((IForgeRegistryEntry)dataSerializerEntryItemList);
    }

    @SubscribeEvent
    public void registerFluids(RegistryEvent.Register<Fluid> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Fluid[]{ModFluids.CANOLA_OIL, ModFluids.CANOLA_OIL_FLOWING, ModFluids.METHANOL, ModFluids.METHANOL_FLOWING, ModFluids.CANOLA_METHANOL_MIX, ModFluids.CANOLA_METHANOL_MIX_FLOWING, ModFluids.GLYCERIN, ModFluids.GLYCERIN_FLOWING, ModFluids.BIO_DIESEL, ModFluids.BIO_DIESEL_FLOWING});
    }

    @SubscribeEvent
    public void registerPointsOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new PointOfInterestType[]{ModPointsOfInterests.POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT});
        try {
            Method register = ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class});
            register.invoke(null, ModPointsOfInterests.POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new VillagerProfession[]{ModVillagerProfessions.VILLAGER_PROFESSION_GAS_STATION_ATTENDANT});
    }
}

