/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.BlockFluidPipe;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import de.maxhenkel.tools.IItemBlock;
import de.maxhenkel.tools.VoxelShapeTools;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class BlockFluidExtractor
extends BlockBase
implements ITileEntityProvider,
IItemBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)0.0);
    public static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_UP = Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)0.0, (double)10.0);
    public static final VoxelShape SHAPE_CORE = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_EXTRACTOR_NORTH = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    public static final VoxelShape SHAPE_EXTRACTOR_SOUTH = Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_EXTRACTOR_EAST = Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_WEST = Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_UP = Block.func_208617_a((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_DOWN = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    protected BlockFluidExtractor() {
        super(Block.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName(new ResourceLocation("car", "fluid_extractor"));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_CAR)).setRegistryName(this.getRegistryName());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityFluidExtractor)) {
            return false;
        }
        TileEntityFluidExtractor fluidExtractor = (TileEntityFluidExtractor)te;
        if (player instanceof ServerPlayerEntity) {
            TileEntityContainerProvider.openGui((ServerPlayerEntity)player, fluidExtractor, (i, playerInventory, playerEntity) -> new ContainerFluidExtractor(i, fluidExtractor, playerInventory));
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l().func_176734_d();
        return (BlockState)this.getState(context.func_195991_k(), context.func_195995_a(), facing).func_206870_a((IProperty)FACING, (Comparable)facing);
    }

    private BlockState getState(World world, BlockPos pos, Direction except) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(except.equals((Object)Direction.UP) ? false : BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.UP)))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(except.equals((Object)Direction.DOWN) ? false : BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.DOWN)))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(except.equals((Object)Direction.NORTH) ? false : BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.NORTH)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(except.equals((Object)Direction.SOUTH) ? false : BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.SOUTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(except.equals((Object)Direction.EAST) ? false : BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.EAST)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(except.equals((Object)Direction.WEST) ? false : BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.WEST)));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.func_220069_a(state, world, pos, block, pos1, b);
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        world.func_175656_a(pos, (BlockState)this.getState(world, pos, facing).func_206870_a((IProperty)FACING, (Comparable)facing));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            shape = VoxelShapeTools.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            shape = VoxelShapeTools.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            shape = VoxelShapeTools.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            shape = VoxelShapeTools.combine(shape, SHAPE_WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            shape = VoxelShapeTools.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            shape = VoxelShapeTools.combine(shape, SHAPE_DOWN);
        }
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                shape = VoxelShapeTools.combine(shape, SHAPE_EXTRACTOR_NORTH, SHAPE_NORTH);
                break;
            }
            case SOUTH: {
                shape = VoxelShapeTools.combine(shape, SHAPE_EXTRACTOR_SOUTH, SHAPE_SOUTH);
                break;
            }
            case EAST: {
                shape = VoxelShapeTools.combine(shape, SHAPE_EXTRACTOR_EAST, SHAPE_EAST);
                break;
            }
            case WEST: {
                shape = VoxelShapeTools.combine(shape, SHAPE_EXTRACTOR_WEST, SHAPE_WEST);
                break;
            }
            case UP: {
                shape = VoxelShapeTools.combine(shape, SHAPE_EXTRACTOR_UP, SHAPE_UP);
                break;
            }
            case DOWN: {
                shape = VoxelShapeTools.combine(shape, SHAPE_EXTRACTOR_DOWN, SHAPE_DOWN);
            }
        }
        return shape;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityFluidExtractor();
    }
}

