/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockFuelStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.BlockTank;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import de.maxhenkel.car.gui.ContainerFuelStation;
import de.maxhenkel.car.gui.ContainerFuelStationAdmin;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import de.maxhenkel.tools.FluidUtils;
import de.maxhenkel.tools.VoxelShapeTools;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockFuelStation
extends BlockOrientableHorizontal {
    public static VoxelShape SHAPE_NORTH_SOUTH = Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)31.0, (double)11.0);
    public static VoxelShape SHAPE_NEAST_WEST = Block.func_208617_a((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)31.0, (double)14.0);
    public static VoxelShape SHAPE_SLAB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.01, (double)16.0);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapeTools.combine(SHAPE_NORTH_SOUTH, SHAPE_SLAB), (Object)Direction.SOUTH, (Object)VoxelShapeTools.combine(SHAPE_NORTH_SOUTH, SHAPE_SLAB), (Object)Direction.EAST, (Object)VoxelShapeTools.combine(SHAPE_NEAST_WEST, SHAPE_SLAB), (Object)Direction.WEST, (Object)VoxelShapeTools.combine(SHAPE_NEAST_WEST, SHAPE_SLAB)));

    public BlockFuelStation() {
        super("fuelstation", Material.field_151573_f, MaterialColor.field_151668_h, SoundType.field_185852_e, 4.0f, 50.0f);
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem(this, new Item.Properties().func_200916_a(ModItemGroups.TAB_CAR)){

            protected boolean func_195944_a(BlockItemUseContext context, BlockState state) {
                if (!context.func_195991_k().func_175623_d(context.func_195995_a().func_177984_a())) {
                    return false;
                }
                return super.func_195944_a(context, state);
            }
        }.setRegistryName(this.getRegistryName());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityFuelStation)) {
            return false;
        }
        TileEntityFuelStation station = (TileEntityFuelStation)te;
        ItemStack stack = player.func_184586_b(handIn);
        if ((station.isOwner(player) || !station.hasTrade()) && stack != null) {
            boolean success1;
            boolean success;
            FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY);
            if (!FluidUtils.isEmpty(fluidStack) && (success = BlockTank.handleEmpty(stack, worldIn, pos, player, handIn))) {
                return true;
            }
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
            if (handler != null && (success1 = BlockTank.handleFill(stack, worldIn, pos, player, handIn))) {
                return true;
            }
        }
        if (!player.func_70093_af()) {
            if (player instanceof ServerPlayerEntity) {
                TileEntityContainerProvider.openGui((ServerPlayerEntity)player, station, (i, playerInventory, playerEntity) -> new ContainerFuelStation(i, station, playerInventory));
            }
            return true;
        }
        if (station.isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                TileEntityContainerProvider.openGui((ServerPlayerEntity)player, station, (i, playerInventory, playerEntity) -> new ContainerFuelStationAdmin(i, station, playerInventory));
            }
            return true;
        }
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te;
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), (BlockState)ModBlocks.FUEL_STATION_TOP.func_176223_P().func_206870_a((IProperty)BlockFuelStationTop.FACING, state.func_177229_b((IProperty)FACING)));
        }
        if ((te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityFuelStation && placer instanceof PlayerEntity) {
            TileEntityFuelStation station = (TileEntityFuelStation)te;
            station.setOwner((PlayerEntity)placer);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        BlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
        if (stateUp != null && stateUp.func_177230_c() != null && stateUp.func_177230_c().equals((Object)ModBlocks.FUEL_STATION_TOP)) {
            worldIn.func_175655_b(pos.func_177984_a(), false);
        }
        BlockFuelStation.dropItems(worldIn, pos);
    }

    public static void dropItems(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFuelStation) {
            TileEntityFuelStation station = (TileEntityFuelStation)te;
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)station.getInventory());
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)station.getTradingInventory());
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityFuelStation();
    }
}

