/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.tools.IItemBlock;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockPaint
extends BlockBase
implements IItemBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.25, (double)16.0);

    public BlockPaint(EnumPaintType type, boolean isYellow) {
        super(Block.Properties.func_200945_a((Material)new Material.Builder(MaterialColor.field_151660_b).func_200506_i()).func_200943_b(2.0f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName(new ResourceLocation("car", type.name + (isYellow ? "_yellow" : "")));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem(this, new Item.Properties()){

            protected boolean func_195944_a(BlockItemUseContext context, BlockState state) {
                if (!BlockPaint.canPlaceBlockAt(context.func_195991_k(), context.func_195995_a())) {
                    return false;
                }
                return super.func_195944_a(context, state);
            }
        }.setRegistryName(this.getRegistryName());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, BlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return BlockPaint.canPlaceBlockAt(worldIn, pos);
    }

    public static boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return BlockPaint.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public static enum EnumPaintType {
        ARROW_FRONT_LEFT_RIGHT_LONG("arrow_front_left_right_long"),
        ARROW_LONG("arrow_long"),
        ARROW_LEFT_LONG("arrow_left"),
        ARROW_RIGHT_LONG("arrow_right"),
        ARROW_LEFT_RIGHT_LONG("arrow_left_right_long"),
        ARROW_FRONT_LEFT_LONG("arrow_front_left_long"),
        ARROW_FRONT_RIGHT_LONG("arrow_front_right_long"),
        ARROW_LEFT_DIA("arrow_left_dia"),
        LINE_RIGHT_DIA("arrow_right_dia"),
        ARROW_FRONT_LEFT_RIGHT("arrow_front_left_right"),
        ARROW("arrow"),
        ARROW_LEFT("arrow_left_short"),
        ARROW_RIGHT("arrow_right_short"),
        ARROW_LEFT_RIGHT("arrow_left_right"),
        ARROW_FRONT_LEFT("arrow_front_left"),
        ARROW_FRONT_RIGHT("arrow_front_right"),
        ARROW_LEFT_DIA_SHORT("arrow_left_dia_short"),
        LINE_RIGHT_DIA_SHORT("arrow_right_dia_short"),
        LINE_MIDDLE("line_middle"),
        LINE_LONG("line_long"),
        LINE_END("line_end"),
        LINE_SIDE_MIDDLE("line_side_middle"),
        LINE_SIDE_LONG("line_side_long"),
        LINE_SIDE_START("line_side_start"),
        LINE_SIDE_END("line_side_end"),
        LINE_SIDE_LONG_LEFT("line_side_long_left"),
        LINE_SIDE_LONG_LEFT_FRONT("line_side_long_left_front"),
        LINE_MIDDLE_EDGE("line_middle_edge"),
        LINE_CORNER("line_corner"),
        LINE_DOUBLE("line_double"),
        LINE_DOUBLE_MIDDLE("line_double_middle"),
        LINE_DOUBLE_END("line_double_end"),
        ARROW_ZEBRAS("arrow_zebras"),
        ARROW_P("arrow_p"),
        ARROW_NO_PARKING("arrow_no_parking"),
        ARROW_CROSS("arrow_cross");

        private String name;

        private EnumPaintType(String name) {
            this.name = name;
        }
    }
}

