/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import de.maxhenkel.tools.IItemBlock;
import de.maxhenkel.tools.VoxelShapeTools;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class BlockSign
extends BlockBase
implements ITileEntityProvider,
IItemBlock {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape SHAPE_NORTH_SOUTH = Block.func_208617_a((double)0.0, (double)3.0, (double)7.5, (double)16.0, (double)13.0, (double)8.5);
    private static final VoxelShape SHAPE_EAST_WEST = Block.func_208617_a((double)7.5, (double)3.0, (double)0.0, (double)8.5, (double)13.0, (double)16.0);
    private static final VoxelShape SHAPE_POST = Block.func_208617_a((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)3.0, (double)8.5);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapeTools.combine(SHAPE_NORTH_SOUTH, SHAPE_POST), (Object)Direction.SOUTH, (Object)VoxelShapeTools.combine(SHAPE_NORTH_SOUTH, SHAPE_POST), (Object)Direction.EAST, (Object)VoxelShapeTools.combine(SHAPE_EAST_WEST, SHAPE_POST), (Object)Direction.WEST, (Object)VoxelShapeTools.combine(SHAPE_EAST_WEST, SHAPE_POST)));

    public BlockSign() {
        super(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_200943_b(20.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName(new ResourceLocation("car", "sign"));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_CAR)).setRegistryName(this.getRegistryName());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntitySign)) {
            return false;
        }
        TileEntitySign sign = (TileEntitySign)te;
        if (player instanceof ServerPlayerEntity) {
            TileEntityContainerProvider.openGui((ServerPlayerEntity)player, sign, (i, playerInventory, playerEntity) -> new ContainerSign(i, sign));
        }
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntitySign();
    }
}

