/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class BlockSplitTankTop
extends BlockBase {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BlockSplitTankTop() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName(new ResourceLocation("car", "split_tank_top"));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return ModBlocks.SPLIT_TANK.func_220051_a(worldIn.func_180495_p(pos.func_177977_b()), worldIn, pos.func_177977_b(), player, handIn, hit);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            if (stateDown != null && stateDown.func_177230_c().equals(ModBlocks.SPLIT_TANK)) {
                worldIn.func_175655_b(pos.func_177977_b(), false);
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (stateDown != null && stateDown.func_177230_c() != null && stateDown.func_177230_c().equals(ModBlocks.SPLIT_TANK) && !player.field_71075_bZ.field_75098_d) {
            ModBlocks.SPLIT_TANK.func_180657_a(world, player, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), world.func_175625_s(pos.func_177977_b()), player.func_184614_ca());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c().equals(ModBlocks.SPLIT_TANK)) {
            return ModBlocks.SPLIT_TANK.getPickBlock(stateDown, target, world, pos.func_177977_b(), player);
        }
        return super.getPickBlock(stateDown, target, world, pos, player);
    }
}

