/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.item.TankItemTileEntityRenderer;
import de.maxhenkel.tools.FluidUtils;
import de.maxhenkel.tools.IItemBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockTank
extends BlockBase
implements ITileEntityProvider,
IItemBlock {
    protected BlockTank() {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f));
        this.setRegistryName(new ResourceLocation("car", "tank"));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_CAR).func_200917_a(1).setTEISR(() -> TankItemTileEntityRenderer::new)).setRegistryName(this.getRegistryName());
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT fluidComp;
        FluidStack fluidStack;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)(fluidComp = stack.func_77978_p().func_74775_l("fluid")))) != null) {
            tooltip.add(new TranslationTextComponent("tooltip.fluid", new Object[]{fluidStack.getDisplayName().func_211708_a(TextFormatting.DARK_GRAY)}).func_211708_a(TextFormatting.GRAY));
            tooltip.add(new TranslationTextComponent("tooltip.amount", new Object[]{new StringTextComponent(String.valueOf(fluidStack.getAmount())).func_211708_a(TextFormatting.DARK_GRAY)}).func_211708_a(TextFormatting.GRAY));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank tank = (TileEntityTank)te;
        BlockTank.applyItemData(stack, tank);
        tank.synchronize();
    }

    public static void applyItemData(ItemStack stack, TileEntityTank tank) {
        if (!stack.func_77942_o()) {
            tank.setFluid(FluidStack.EMPTY);
            return;
        }
        CompoundNBT comp = stack.func_77978_p();
        if (!comp.func_74764_b("fluid")) {
            return;
        }
        CompoundNBT fluidTag = comp.func_74775_l("fluid");
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
        tank.setFluid(fluidStack);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (FluidUtil.getFluidContained((ItemStack)stack).orElse(null) != null) {
            FluidUtils.tryFluidInteraction(player, handIn, worldIn, pos);
            return true;
        }
        return false;
    }

    public static boolean handleEmpty(ItemStack stack, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (PlayerEntity)playerIn, (boolean)true);
        if (res.isSuccess()) {
            playerIn.func_184611_a(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(ItemStack stack, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler blockHandler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)blockHandler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (PlayerEntity)playerIn, (boolean)true);
        if (result.isSuccess()) {
            playerIn.func_184611_a(hand, result.result);
            return true;
        }
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean doesSideBlockRendering(BlockState state, IEnviromentBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader reader, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityTank();
    }

    public boolean func_190946_v(BlockState state) {
        return true;
    }
}

