/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockAsphalt;
import de.maxhenkel.car.blocks.BlockAsphaltSlab;
import de.maxhenkel.car.blocks.BlockAsphaltSlope;
import de.maxhenkel.car.blocks.BlockAsphaltSlopeFlat;
import de.maxhenkel.car.blocks.BlockBackmixReactor;
import de.maxhenkel.car.blocks.BlockBlastFurnace;
import de.maxhenkel.car.blocks.BlockCable;
import de.maxhenkel.car.blocks.BlockCanolaCrop;
import de.maxhenkel.car.blocks.BlockCarWorkshop;
import de.maxhenkel.car.blocks.BlockCarWorkshopOutter;
import de.maxhenkel.car.blocks.BlockCrank;
import de.maxhenkel.car.blocks.BlockCrashBarrier;
import de.maxhenkel.car.blocks.BlockDynamo;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.BlockFluidPipe;
import de.maxhenkel.car.blocks.BlockFuelStation;
import de.maxhenkel.car.blocks.BlockFuelStationTop;
import de.maxhenkel.car.blocks.BlockGenerator;
import de.maxhenkel.car.blocks.BlockOilMill;
import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.BlockSign;
import de.maxhenkel.car.blocks.BlockSignPost;
import de.maxhenkel.car.blocks.BlockSplitTank;
import de.maxhenkel.car.blocks.BlockSplitTankTop;
import de.maxhenkel.car.blocks.BlockTank;
import de.maxhenkel.car.blocks.fluid.CarFluidBlock;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.tools.IItemBlock;
import de.maxhenkel.tools.NoRegister;
import de.maxhenkel.tools.OnlyBlock;
import de.maxhenkel.tools.ReflectionTools;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;

public class ModBlocks {
    public static final BlockAsphalt ASPHALT;
    public static final BlockAsphaltSlope ASPHALT_SLOPE;
    public static final BlockAsphaltSlopeFlat ASPHALT_SLOPE_FLAT_UPPER;
    public static final BlockAsphaltSlopeFlat ASPHALT_SLOPE_FLAT_LOWER;
    public static final BlockAsphaltSlab ASPHALT_SLAB;
    public static final BlockFuelStation FUEL_STATION;
    @OnlyBlock
    public static final BlockFuelStationTop FUEL_STATION_TOP;
    @OnlyBlock
    public static final BlockCanolaCrop CANOLA_CROP;
    public static final BlockOilMill OIL_MILL;
    public static final BlockBlastFurnace BLAST_FURNACE;
    public static final BlockBackmixReactor BACKMIX_REACTOR;
    public static final BlockGenerator GENERATOR;
    public static final BlockSplitTank SPLIT_TANK;
    @OnlyBlock
    public static final BlockSplitTankTop SPLIT_TANK_TOP;
    public static final BlockTank TANK;
    public static final BlockCrashBarrier CRASH_BARRIER;
    public static final BlockCarWorkshop CAR_WORKSHOP;
    public static final BlockCarWorkshopOutter CAR_WORKSHOP_OUTTER;
    public static final BlockCable CABLE;
    public static final BlockFluidExtractor FLUID_EXTRACTOR;
    public static final BlockFluidPipe FLUID_PIPE;
    public static final BlockDynamo DYNAMO;
    public static final BlockCrank CRANK;
    public static final BlockSign SIGN;
    public static final BlockSignPost SIGN_POST;
    public static final FlowingFluidBlock BIO_DIESEL;
    public static final FlowingFluidBlock CANOLA_METHANOL_MIX;
    public static final FlowingFluidBlock CANOLA_OIL;
    public static final FlowingFluidBlock GLYCERIN;
    public static final FlowingFluidBlock METHANOL;
    public static final BlockPaint[] PAINTS;
    public static final BlockPaint[] YELLOW_PAINTS;

    public static List<IItemBlock> getBlocksWithItems() {
        ArrayList<IItemBlock> blocks = new ArrayList<IItemBlock>();
        for (Field field : ModBlocks.class.getFields()) {
            if (ReflectionTools.hasAnnotation(field, NoRegister.class) || ReflectionTools.hasAnnotation(field, OnlyBlock.class)) continue;
            try {
                Object obj = field.get(null);
                if (obj == null || !(obj instanceof IItemBlock)) continue;
                blocks.add((IItemBlock)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        blocks.addAll(Arrays.asList(PAINTS));
        blocks.addAll(Arrays.asList(YELLOW_PAINTS));
        return blocks;
    }

    public static List<Block> getAll() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Field field : ModBlocks.class.getFields()) {
            if (ReflectionTools.hasAnnotation(field, NoRegister.class)) continue;
            try {
                Object obj = field.get(null);
                if (obj == null || !(obj instanceof Block)) continue;
                blocks.add((Block)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        blocks.addAll(Arrays.asList(PAINTS));
        blocks.addAll(Arrays.asList(YELLOW_PAINTS));
        return blocks;
    }

    static {
        int i;
        ASPHALT = new BlockAsphalt();
        ASPHALT_SLOPE = new BlockAsphaltSlope();
        ASPHALT_SLOPE_FLAT_UPPER = new BlockAsphaltSlopeFlat(true);
        ASPHALT_SLOPE_FLAT_LOWER = new BlockAsphaltSlopeFlat(false);
        ASPHALT_SLAB = new BlockAsphaltSlab();
        FUEL_STATION = new BlockFuelStation();
        FUEL_STATION_TOP = new BlockFuelStationTop();
        CANOLA_CROP = new BlockCanolaCrop();
        OIL_MILL = new BlockOilMill();
        BLAST_FURNACE = new BlockBlastFurnace();
        BACKMIX_REACTOR = new BlockBackmixReactor();
        GENERATOR = new BlockGenerator();
        SPLIT_TANK = new BlockSplitTank();
        SPLIT_TANK_TOP = new BlockSplitTankTop();
        TANK = new BlockTank();
        CRASH_BARRIER = new BlockCrashBarrier();
        CAR_WORKSHOP = new BlockCarWorkshop();
        CAR_WORKSHOP_OUTTER = new BlockCarWorkshopOutter();
        CABLE = new BlockCable();
        FLUID_EXTRACTOR = new BlockFluidExtractor();
        FLUID_PIPE = new BlockFluidPipe();
        DYNAMO = new BlockDynamo();
        CRANK = new BlockCrank();
        SIGN = new BlockSign();
        SIGN_POST = new BlockSignPost();
        BIO_DIESEL = new CarFluidBlock(() -> ModFluids.BIO_DIESEL);
        CANOLA_METHANOL_MIX = new CarFluidBlock(() -> ModFluids.CANOLA_METHANOL_MIX);
        CANOLA_OIL = new CarFluidBlock(() -> ModFluids.CANOLA_OIL);
        GLYCERIN = new CarFluidBlock(() -> ModFluids.GLYCERIN);
        METHANOL = new CarFluidBlock(() -> ModFluids.METHANOL);
        PAINTS = new BlockPaint[BlockPaint.EnumPaintType.values().length];
        for (i = 0; i < PAINTS.length; ++i) {
            ModBlocks.PAINTS[i] = new BlockPaint(BlockPaint.EnumPaintType.values()[i], false);
        }
        YELLOW_PAINTS = new BlockPaint[BlockPaint.EnumPaintType.values().length];
        for (i = 0; i < YELLOW_PAINTS.length; ++i) {
            ModBlocks.YELLOW_PAINTS[i] = new BlockPaint(BlockPaint.EnumPaintType.values()[i], true);
        }
    }
}

