/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockFuelStation;
import de.maxhenkel.car.blocks.BlockFuelStationTop;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopTileentity;
import de.maxhenkel.tools.FluidUtils;
import de.maxhenkel.tools.ItemTools;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFuelStation
extends TileEntityBase
implements ITickableTileEntity,
IFluidHandler,
SoundLoopTileentity.ISoundLoopable,
IInventory {
    private FluidStack storage;
    public int maxStorageAmount = 16000;
    private final int transferRate;
    private int fuelCounter = 0;
    private boolean isFueling;
    private boolean wasFueling;
    private Inventory inventory;
    private Inventory trading;
    private int tradeAmount;
    private int freeAmountLeft;
    private UUID owner;
    public final IIntArray FIELDS = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityFuelStation.this.fuelCounter;
                }
                case 1: {
                    if (!FluidUtils.isEmpty(TileEntityFuelStation.this.storage)) {
                        return TileEntityFuelStation.this.storage.getAmount();
                    }
                    return 0;
                }
                case 2: {
                    return TileEntityFuelStation.this.tradeAmount;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityFuelStation.this.fuelCounter = value;
                    break;
                }
                case 1: {
                    if (FluidUtils.isEmpty(TileEntityFuelStation.this.storage)) break;
                    TileEntityFuelStation.this.storage.setAmount(value);
                    break;
                }
                case 2: {
                    TileEntityFuelStation.this.tradeAmount = value;
                    TileEntityFuelStation.this.func_70296_d();
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public TileEntityFuelStation() {
        super(Main.FUEL_STATION_TILE_ENTITY_TYPE);
        this.transferRate = (Integer)Config.fuelStationTransferRate.get();
        this.inventory = new Inventory(27);
        this.trading = new Inventory(2);
        this.owner = new UUID(0L, 0L);
        this.storage = FluidStack.EMPTY;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.fuel_station", new Object[0]);
    }

    private void fixTop() {
        BlockState top = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        BlockState bottom = this.field_145850_b.func_180495_p(this.field_174879_c);
        Direction facing = (Direction)bottom.func_177229_b((IProperty)BlockFuelStation.FACING);
        if (top.func_177230_c().equals((Object)ModBlocks.FUEL_STATION_TOP)) {
            if (!((Direction)top.func_177229_b((IProperty)BlockFuelStationTop.FACING)).equals((Object)facing)) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), (BlockState)ModBlocks.FUEL_STATION_TOP.func_176223_P().func_206870_a((IProperty)BlockFuelStationTop.FACING, (Comparable)facing));
            }
        } else if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), (BlockState)ModBlocks.FUEL_STATION_TOP.func_176223_P().func_206870_a((IProperty)BlockFuelStationTop.FACING, (Comparable)facing));
        }
    }

    public void func_73660_a() {
        FluidStack result;
        IFluidHandler handler;
        if (this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.fixTop();
        }
        if ((handler = this.getFluidHandlerInFront()) == null) {
            if (this.fuelCounter > 0 || this.isFueling) {
                this.fuelCounter = 0;
                this.isFueling = false;
                this.synchronize();
                this.func_70296_d();
            }
            return;
        }
        if (!this.isFueling) {
            return;
        }
        if (FluidUtils.isEmpty(this.storage)) {
            return;
        }
        FluidStack s = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        int amountCarCanTake = 0;
        if (!FluidUtils.isEmpty(s)) {
            amountCarCanTake = s.getAmount();
        }
        if (amountCarCanTake <= 0) {
            return;
        }
        if (this.freeAmountLeft <= 0) {
            if (this.tradeAmount <= 0) {
                this.freeAmountLeft = this.transferRate;
                this.func_70296_d();
            } else if (this.removeTradeItem()) {
                this.freeAmountLeft = this.tradeAmount;
                this.func_70296_d();
            } else {
                this.isFueling = false;
                this.synchronize();
                return;
            }
        }
        if (!FluidUtils.isEmpty(result = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)Math.min(this.transferRate, this.freeAmountLeft), (boolean)true))) {
            this.fuelCounter += result.getAmount();
            this.freeAmountLeft -= result.getAmount();
            this.synchronize(100);
            this.func_70296_d();
            if (!this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = true;
        } else {
            if (this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = false;
        }
    }

    public boolean removeTradeItem() {
        ItemStack tradeTemplate = this.trading.func_70301_a(0);
        ItemStack tradingStack = this.trading.func_70301_a(1);
        if (tradeTemplate.func_190926_b()) {
            return true;
        }
        if (tradingStack.func_190926_b()) {
            return false;
        }
        if (!tradeTemplate.func_77973_b().equals(tradingStack.func_77973_b())) {
            return false;
        }
        if (tradeTemplate.func_77952_i() != tradingStack.func_77952_i()) {
            return false;
        }
        if (tradingStack.func_190916_E() < tradeTemplate.func_190916_E()) {
            return false;
        }
        ItemStack addStack = tradingStack.func_77946_l();
        addStack.func_190920_e(tradeTemplate.func_190916_E());
        ItemStack add = this.inventory.func_174894_a(addStack);
        if (add.func_190916_E() > 0) {
            return false;
        }
        tradingStack.func_190920_e(tradingStack.func_190916_E() - tradeTemplate.func_190916_E());
        this.trading.func_70299_a(1, tradingStack);
        return true;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public IInventory getTradingInventory() {
        return this.trading;
    }

    public boolean isValidFluid(Fluid f) {
        return Config.fuelStationValidFuelList.contains(f);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public void setOwner(PlayerEntity player) {
        this.owner = new UUID(player.func_110124_au().getMostSignificantBits(), player.func_110124_au().getLeastSignificantBits());
        this.func_70296_d();
    }

    public boolean isOwner(PlayerEntity player) {
        ServerPlayerEntity p;
        boolean isOp;
        if (player instanceof ServerPlayerEntity && (isOp = (p = (ServerPlayerEntity)player).func_211513_k(p.field_71133_b.func_110455_j()))) {
            return true;
        }
        return player.func_110124_au().equals(this.owner);
    }

    public boolean hasTrade() {
        return !this.trading.func_70301_a(0).func_190926_b();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("counter", this.fuelCounter);
        if (!FluidUtils.isEmpty(this.storage)) {
            CompoundNBT comp = new CompoundNBT();
            this.storage.writeToNBT(comp);
            compound.func_218657_a("fluid", (INBT)comp);
        }
        ItemTools.saveInventory(compound, "inventory", (IInventory)this.inventory);
        ItemTools.saveInventory(compound, "trading", (IInventory)this.trading);
        compound.func_74768_a("trade_amount", this.tradeAmount);
        compound.func_74768_a("free_amount", this.freeAmountLeft);
        compound.func_186854_a("owner", this.owner);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.fuelCounter = compound.func_74762_e("counter");
        if (compound.func_74764_b("fluid")) {
            CompoundNBT comp = compound.func_74775_l("fluid");
            this.storage = FluidStack.loadFluidStackFromNBT((CompoundNBT)comp);
        }
        ItemTools.readInventory(compound, "inventory", (IInventory)this.inventory);
        ItemTools.readInventory(compound, "trading", (IInventory)this.trading);
        this.tradeAmount = compound.func_74762_e("trade_amount");
        this.freeAmountLeft = compound.func_74762_e("free_amount");
        this.owner = compound.func_186857_a("owner");
        super.func_145839_a(compound);
    }

    public boolean isFueling() {
        return this.isFueling;
    }

    public int getFuelCounter() {
        return this.fuelCounter;
    }

    public void setStorage(FluidStack storage) {
        this.storage = storage;
        this.func_70296_d();
        this.synchronize();
    }

    public FluidStack getStorage() {
        return this.storage;
    }

    public void setFuelCounter(int fuelCounter) {
        this.fuelCounter = fuelCounter;
        this.func_70296_d();
        this.synchronize();
    }

    public void setFueling(boolean isFueling) {
        if (this.getFluidHandlerInFront() == null) {
            return;
        }
        if (isFueling && !this.isFueling && this.field_145850_b.field_72995_K) {
            this.playSound();
        }
        this.isFueling = isFueling;
        this.synchronize();
    }

    public String getRenderText() {
        IFluidHandler fluidHandler = this.getFluidHandlerInFront();
        if (fluidHandler == null) {
            return new TranslationTextComponent("fuelstation.no_car", new Object[0]).func_150254_d();
        }
        if (this.fuelCounter <= 0) {
            return new TranslationTextComponent("fuelstation.ready", new Object[0]).func_150254_d();
        }
        return new TranslationTextComponent("fuelstation.fuel_amount", new Object[]{this.fuelCounter}).func_150254_d();
    }

    public IFluidHandler getFluidHandlerInFront() {
        BlockState ownState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!ownState.func_177230_c().equals(ModBlocks.FUEL_STATION)) {
            return null;
        }
        Direction facing = (Direction)ownState.func_177229_b((IProperty)BlockFuelStation.FACING);
        BlockPos start = this.func_174877_v().func_177972_a(facing);
        AxisAlignedBB aabb = new AxisAlignedBB((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p(), (double)start.func_177958_n() + 1.0, (double)start.func_177956_o() + 2.5, (double)start.func_177952_p() + 1.0).func_72321_a((double)facing.func_82601_c(), 0.0, (double)facing.func_82599_e());
        List entities = this.field_145850_b.func_217357_a(Entity.class, aabb);
        if (entities.isEmpty()) {
            return null;
        }
        return (IFluidHandler)((Entity)entities.get(0)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
    }

    public boolean canEntityBeFueled() {
        IFluidHandler handler = this.getFluidHandlerInFront();
        if (handler == null) {
            return false;
        }
        FluidStack result = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        return !FluidUtils.isEmpty(result) && result.getAmount() > 0;
    }

    public BlockState func_195044_w() {
        BlockState ownState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!ownState.func_177230_c().equals(ModBlocks.FUEL_STATION)) {
            return null;
        }
        return ownState;
    }

    public Direction getDirection() {
        BlockState state = this.func_195044_w();
        if (state == null) {
            return Direction.NORTH;
        }
        return (Direction)state.func_177229_b((IProperty)BlockFuelStation.FACING);
    }

    public void sendStartFuelPacket(boolean start) {
        if (this.field_145850_b.field_72995_K) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStartFuel(this.field_174879_c, start));
        }
    }

    @Override
    public boolean shouldSoundBePlayed() {
        if (!this.isFueling) {
            return false;
        }
        return this.canEntityBeFueled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
        ModSounds.playSoundLoop(new SoundLoopTileentity(ModSounds.GAS_STATION, SoundCategory.BLOCKS, this), this.field_145850_b);
    }

    @Override
    public void play() {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_191420_l() {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public void func_174888_l() {
    }

    public int getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(int tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public int getFuelAmount() {
        if (!FluidUtils.isEmpty(this.storage)) {
            return this.storage.getAmount();
        }
        return 0;
    }

    @Override
    public IIntArray getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.storage;
    }

    public int getTankCapacity(int tank) {
        return this.maxStorageAmount;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFluid(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isValidFluid(resource.getFluid())) {
            return 0;
        }
        if (FluidUtils.isEmpty(this.storage)) {
            int amount = Math.min(resource.getAmount(), this.maxStorageAmount);
            if (action.execute()) {
                this.storage = new FluidStack(resource.getFluid(), amount);
                this.synchronize();
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.storage.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.maxStorageAmount - this.storage.getAmount());
            if (action.execute()) {
                this.storage.setAmount(this.storage.getAmount() + amount);
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (FluidUtils.isEmpty(this.storage)) {
            return FluidStack.EMPTY;
        }
        if (this.storage.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.storage.getAmount());
            Fluid f = this.storage.getFluid();
            if (action.execute()) {
                this.storage.setAmount(this.storage.getAmount() - amount);
                if (this.storage.getAmount() <= 0) {
                    this.storage = FluidStack.EMPTY;
                    this.synchronize();
                }
                this.func_70296_d();
            }
            return new FluidStack(f, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (FluidUtils.isEmpty(this.storage)) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.storage.getAmount());
        Fluid f = this.storage.getFluid();
        if (action.execute()) {
            this.storage.setAmount(this.storage.getAmount() - amount);
            if (this.storage.getAmount() <= 0) {
                this.storage = FluidStack.EMPTY;
                this.synchronize();
            }
            this.func_70296_d();
        }
        return new FluidStack(f, amount);
    }
}

