/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererSplitTank
extends TileEntityRenderer<TileEntitySplitTank> {
    private static final FluidStack BIO_DIESEL_STACK = new FluidStack((Fluid)ModFluids.BIO_DIESEL, 1);
    private static final FluidStack GLYCERIN_STACK = new FluidStack((Fluid)ModFluids.GLYCERIN, 1);

    public void render(TileEntitySplitTank te, double x, double y, double z, float partialTicks, int destroyStage) {
        this.func_147499_a(AtlasTexture.field_110575_b);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        float bioDiesel = te.getBioDieselPerc() / 2.0f;
        float glycerin = te.getGlycerinPerc() / 2.0f;
        if (bioDiesel > 0.0f) {
            this.renderFluid(BIO_DIESEL_STACK, bioDiesel, 0.0625f);
        }
        if (glycerin > 0.0f) {
            this.renderFluid(GLYCERIN_STACK, glycerin, bioDiesel + 0.0625f);
        }
        GlStateManager.popMatrix();
    }

    public void renderFluid(FluidStack fluid, float amount, float yStart) {
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.translatef((float)0.01f, (float)0.01f, (float)0.01f);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.blendFunc((int)770, (int)771);
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getAttributes().getStill(fluid).toString());
        double uMin = texture.func_94209_e();
        double uMax = texture.func_94212_f();
        double vMin = texture.func_94206_g();
        double vMax = texture.func_94210_h();
        double vHeight = vMax - vMin;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float s = 0.0f;
        buffer.func_181662_b((double)(1.0f - s), (double)yStart, (double)(0.0f + s)).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)yStart, (double)(0.0f + s)).func_187315_a(uMin, vMin).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)(yStart + amount - s * 2.0f), (double)(0.0f + s)).func_187315_a(uMin, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)(yStart + amount - s * 2.0f), (double)(0.0f + s)).func_187315_a(uMax, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)yStart, (double)(1.0f - s)).func_187315_a(uMin, vMin).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)(yStart + amount - s * 2.0f), (double)(1.0f - s)).func_187315_a(uMin, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)(yStart + amount - s * 2.0f), (double)(1.0f - s)).func_187315_a(uMax, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)yStart, (double)(1.0f - s)).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)yStart, (double)(0.0f + s)).func_187315_a(uMin, vMin).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)(yStart + amount - s * 2.0f), (double)(0.0f + s)).func_187315_a(uMin, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)(yStart + amount - s * 2.0f), (double)(1.0f - s)).func_187315_a(uMax, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)yStart, (double)(1.0f - s)).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)yStart, (double)(1.0f - s)).func_187315_a(uMin, vMin).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)(yStart + amount - s * 2.0f), (double)(1.0f - s)).func_187315_a(uMin, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)(yStart + amount - s * 2.0f), (double)(0.0f + s)).func_187315_a(uMax, vMin + vHeight * (double)amount).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)yStart, (double)(0.0f + s)).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)yStart, (double)(0.0f + s)).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)yStart, (double)(1.0f - s)).func_187315_a(uMin, vMin).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)yStart, (double)(1.0f - s)).func_187315_a(uMin, vMax).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)yStart, (double)(0.0f + s)).func_187315_a(uMax, vMax).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)(yStart + amount - s * 2.0f), (double)(0.0f + s)).func_187315_a(uMax, vMax).func_181675_d();
        buffer.func_181662_b((double)(0.0f + s), (double)(yStart + amount - s * 2.0f), (double)(1.0f - s)).func_187315_a(uMin, vMax).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)(yStart + amount - s * 2.0f), (double)(1.0f - s)).func_187315_a(uMin, vMin).func_181675_d();
        buffer.func_181662_b((double)(1.0f - s), (double)(yStart + amount - s * 2.0f), (double)(0.0f + s)).func_187315_a(uMax, vMin).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.popMatrix();
    }
}

