/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererTank
extends TileEntityRenderer<TileEntityTank> {
    public static final ResourceLocation LOCATION_TANK = new ResourceLocation("car", "textures/block/tank_line.png");

    public void render(TileEntityTank te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (destroyStage >= 0) {
            this.renderDestroyStages(te, x, y, z, partialTicks, destroyStage);
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.blendFunc((int)770, (int)771);
        double amount = te.getFillPercent();
        FluidStack stack = te.getFluid();
        if (amount > 0.0 && stack != null) {
            this.renderFluid(te, stack, amount, 0.0);
        }
        this.func_147499_a(LOCATION_TANK);
        TileEntitySpecialRendererTank.renderLines(te);
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.popMatrix();
    }

    public void renderDestroyStages(TileEntityTank te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.disableLighting();
        this.func_147499_a(field_178460_a[destroyStage]);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(1.0, 0.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    public void renderFluid(TileEntityTank tank, FluidStack fluid, double amount, double yStart) {
        this.func_147499_a(AtlasTexture.field_110575_b);
        GlStateManager.pushMatrix();
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getAttributes().getStill(fluid).toString());
        double uMin = texture.func_94209_e();
        double uMax = texture.func_94212_f();
        double vMin = texture.func_94206_g();
        double vMax = texture.func_94210_h();
        double vHeight = vMax - vMin;
        int i = tank.func_145830_o() ? fluid.getFluid().getAttributes().getColor((IEnviromentBlockReader)tank.func_145831_w(), tank.func_174877_v()) : fluid.getFluid().getAttributes().getColor();
        float red = (float)(i >> 16 & 0xFF) / 255.0f;
        float green = (float)(i >> 8 & 0xFF) / 255.0f;
        float blue = (float)(i & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float s = 0.0f;
        if (!tank.isFluidConnected(Direction.NORTH)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 0.0 + (double)s).func_187315_a(uMin, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (!tank.isFluidConnected(Direction.SOUTH)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 1.0 - (double)s).func_187315_a(uMax, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (!tank.isFluidConnected(Direction.EAST)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 0.0 + (double)s).func_187315_a(uMin, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart, 1.0 - (double)s).func_187315_a(uMax, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (!tank.isFluidConnected(Direction.WEST)) {
            buffer.func_181662_b(0.0 + (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMin + vHeight * amount).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (!tank.isFluidConnected(Direction.DOWN)) {
            buffer.func_181662_b(1.0 - (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 1.0 - (double)s).func_187315_a(uMin, vMax).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart, 0.0 + (double)s).func_187315_a(uMax, vMax).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (!tank.isFluidConnected(Direction.UP)) {
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMax).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(0.0 + (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMax).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 1.0 - (double)s).func_187315_a(uMin, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(1.0 - (double)s, yStart + amount - (double)s * 2.0, 0.0 + (double)s).func_187315_a(uMax, vMin).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
    }

    public static void renderLines(TileEntityTank te) {
        for (Direction facing : Direction.values()) {
            if (te.isTankConnectedTo(facing)) continue;
            for (EnumDirection direction : EnumDirection.values()) {
                if (te.isTankConnectedTo(direction.to(facing))) continue;
                TileEntitySpecialRendererTank.drawLine(facing, direction);
            }
        }
    }

    public static void drawLine(Direction side, EnumDirection line) {
        GlStateManager.pushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TileEntitySpecialRendererTank.rotate(side);
        GlStateManager.scaled((double)1.01, (double)1.01, (double)1.01);
        GlStateManager.translated((double)-0.005, (double)-0.005, (double)-0.005);
        TileEntitySpecialRendererTank.drawSide(line, side, buffer);
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
    }

    public static void rotate(Direction facing) {
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        switch (facing) {
            case NORTH: {
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
    }

    public static void drawSide(EnumDirection line, Direction side, BufferBuilder buffer) {
        switch (line) {
            case UP: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                break;
            }
            case DOWN: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                break;
            }
            case RIGHT: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                break;
            }
            case LEFT: {
                buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                buffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                break;
            }
        }
    }

    public static enum EnumDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public Direction to(Direction facing) {
            switch (facing) {
                case NORTH: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.EAST;
                        }
                        case RIGHT: {
                            return Direction.WEST;
                        }
                    }
                }
                case SOUTH: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
                case EAST: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.SOUTH;
                        }
                        case RIGHT: {
                            return Direction.NORTH;
                        }
                    }
                }
                case WEST: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.NORTH;
                        }
                        case RIGHT: {
                            return Direction.SOUTH;
                        }
                    }
                }
                case UP: {
                    switch (this) {
                        case UP: {
                            return Direction.NORTH;
                        }
                        case DOWN: {
                            return Direction.SOUTH;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
                case DOWN: {
                    switch (this) {
                        case UP: {
                            return Direction.SOUTH;
                        }
                        case DOWN: {
                            return Direction.NORTH;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
            }
            return Direction.UP;
        }
    }
}

