/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.items.ItemCanister;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.tools.FluidUtils;
import de.maxhenkel.tools.ItemTools;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class EntityCarInventoryBase
extends EntityCarFuelBase
implements IInventory {
    protected IInventory internalInventory;
    protected IInventory externalInventory;
    protected IInventory partInventory;
    protected FluidStack fluidInventory;
    private IFluidHandler inventoryFluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return EntityCarInventoryBase.this.fluidInventory;
        }

        public int getTankCapacity(int tank) {
            return EntityCarInventoryBase.this.getFluidInventorySize();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidUtils.isEmpty(EntityCarInventoryBase.this.fluidInventory)) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.getFluidInventorySize());
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory = new FluidStack(resource.getFluid(), amount);
                }
                return amount;
            }
            if (resource.getFluid().equals(EntityCarInventoryBase.this.fluidInventory.getFluid())) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.getFluidInventorySize() - EntityCarInventoryBase.this.fluidInventory.getAmount());
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() + amount);
                }
                return amount;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidUtils.isEmpty(EntityCarInventoryBase.this.fluidInventory)) {
                return FluidStack.EMPTY;
            }
            if (EntityCarInventoryBase.this.fluidInventory.getFluid().equals(resource.getFluid())) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.fluidInventory.getAmount());
                Fluid f = EntityCarInventoryBase.this.fluidInventory.getFluid();
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - amount);
                    if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                        EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                    }
                }
                return new FluidStack(f, amount);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (FluidUtils.isEmpty(EntityCarInventoryBase.this.fluidInventory)) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(maxDrain, EntityCarInventoryBase.this.fluidInventory.getAmount());
            Fluid f = EntityCarInventoryBase.this.fluidInventory.getFluid();
            if (action.execute()) {
                EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - amount);
                if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                    EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                }
            }
            return new FluidStack(f, amount);
        }
    };

    public EntityCarInventoryBase(EntityType type, World worldIn) {
        super(type, worldIn);
        this.internalInventory = new Inventory(27);
        this.externalInventory = new Inventory(0);
        this.partInventory = new Inventory(15);
        this.fluidInventory = FluidStack.EMPTY;
    }

    @Override
    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (this.canPlayerAccessInventoryExternal(player) && player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b()) {
                IFluidHandler handler;
                if (stack.func_77973_b() instanceof ItemCanister) {
                    boolean success = ItemCanister.fillCanister(stack, this);
                    if (success) {
                        ModSounds.playSound(SoundEvents.field_187621_J, this.field_70170_p, this.func_180425_c(), null, SoundCategory.BLOCKS);
                    }
                    return true;
                }
                if (this.getFluidInventorySize() > 0 && (handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)) != null) {
                    FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY);
                    if (!FluidUtils.isEmpty(fluidStack) && EntityCarInventoryBase.handleEmpty(stack, this.getInventoryFluidHandler(), player, hand)) {
                        return true;
                    }
                    if (EntityCarInventoryBase.handleFill(stack, this.getInventoryFluidHandler(), player, hand)) {
                        return true;
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.externalInventory.func_70302_i_() <= 0) {
                    this.openCarGUI(player);
                } else {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                        public ITextComponent func_145748_c_() {
                            return EntityCarInventoryBase.this.func_145748_c_();
                        }

                        @Nullable
                        public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                            return new ContainerCarInventory(i, EntityCarInventoryBase.this, playerInventory);
                        }
                    }, packetBuffer -> packetBuffer.func_179252_a(this.func_110124_au()));
                }
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public static boolean handleEmpty(ItemStack stack, IFluidHandler handler, PlayerEntity playerIn, Hand hand) {
        InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (PlayerEntity)playerIn, (boolean)true);
        if (res.isSuccess()) {
            playerIn.func_184611_a(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(ItemStack stack, IFluidHandler handler, PlayerEntity playerIn, Hand hand) {
        InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (PlayerEntity)playerIn, (boolean)true);
        if (result.isSuccess()) {
            playerIn.func_184611_a(hand, result.result);
            return true;
        }
        return false;
    }

    public abstract int getFluidInventorySize();

    public boolean canPlayerAccessInventoryExternal(PlayerEntity player) {
        return true;
    }

    public IInventory getPartInventory() {
        return this.partInventory;
    }

    @Override
    public void destroyCar(PlayerEntity player, boolean dropParts) {
        super.destroyCar(player, dropParts);
        InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.externalInventory);
        if (dropParts) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.partInventory);
        }
    }

    @Override
    public void openCarGUI(PlayerEntity player) {
        super.openCarGUI(player);
        if (!this.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return EntityCarInventoryBase.this.func_145748_c_();
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new ContainerCar(i, EntityCarInventoryBase.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.func_179252_a(this.func_110124_au()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemTools.readInventory(compound, "int_inventory", this.internalInventory);
        this.externalInventory = new Inventory(compound.func_74762_e("external_inventory_size"));
        ItemTools.readInventory(compound, "external_inventory", this.externalInventory);
        ItemTools.readInventory(compound, "parts", this.partInventory);
        if (compound.func_74764_b("fluid_inventory")) {
            this.fluidInventory = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound.func_74775_l("fluid_inventory"));
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemTools.saveInventory(compound, "int_inventory", this.internalInventory);
        compound.func_74768_a("external_inventory_size", this.externalInventory.func_70302_i_());
        ItemTools.saveInventory(compound, "external_inventory", this.externalInventory);
        ItemTools.saveInventory(compound, "parts", this.partInventory);
        if (!FluidUtils.isEmpty(this.fluidInventory)) {
            compound.func_218657_a("fluid_inventory", (INBT)this.fluidInventory.writeToNBT(new CompoundNBT()));
        }
    }

    public IFluidHandler getInventoryFluidHandler() {
        return this.inventoryFluidHandler;
    }

    public int func_70302_i_() {
        return this.internalInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.internalInventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.internalInventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.internalInventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.internalInventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.internalInventory.func_70297_j_();
    }

    public void func_70296_d() {
        this.internalInventory.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.internalInventory.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.internalInventory.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
        this.internalInventory.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.internalInventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.internalInventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.internalInventory.func_174888_l();
    }

    public IInventory getExternalInventory() {
        return this.externalInventory;
    }
}

