/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Config;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityVehicleBase
extends Entity {
    public static float SCALE_FACTOR = 0.7f;
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;
    protected AxisAlignedBB field_70121_D;

    public EntityVehicleBase(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
        this.field_70138_W = 0.6f;
        this.recalculateBoundingBox();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
        }
        this.func_184189_br();
        super.func_70071_h_();
        this.tickLerp();
        this.recalculateBoundingBox();
    }

    public void recalculateBoundingBox() {
        double width = this.getCarWidth();
        double height = this.getCarHeight();
        this.field_70121_D = new AxisAlignedBB(this.field_70165_t - width / 2.0, this.field_70163_u, this.field_70161_v - width / 2.0, this.field_70165_t + width / 2.0, this.field_70163_u + height, this.field_70161_v + width / 2.0);
    }

    public double getCarWidth() {
        return 1.3;
    }

    public double getCarHeight() {
        return 1.6;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (passenger instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)passenger;
            Direction facing = this.func_174811_aO();
            double offsetX = 0.0;
            double offsetZ = 0.0;
            for (int i = 0; i < 4; ++i) {
                AxisAlignedBB playerbb = player.func_174813_aQ();
                double playerHitboxWidth = playerbb.func_216364_b() / 2.0;
                double carHitboxWidth = this.getCarWidth() / 2.0;
                double offset = playerHitboxWidth + carHitboxWidth + 0.2;
                AxisAlignedBB aabb = player.func_174813_aQ().func_72317_d(offsetX += (double)facing.func_82601_c() * offset, 0.0, offsetZ += (double)facing.func_82599_e() * offset);
                if (!this.field_70170_p.func_72829_c(aabb) && this.field_70170_p.func_217346_i((Entity)player)) break;
                offsetX = 0.0;
                offsetZ = 0.0;
                facing = facing.func_176746_e();
            }
            player.func_70634_a(this.field_70165_t + offsetX, this.field_70163_u, this.field_70161_v + offsetZ);
        }
    }

    public PlayerEntity getDriver() {
        List passengers = this.func_184188_bt();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof PlayerEntity) {
            return (PlayerEntity)passengers.get(0);
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public abstract Vec3d[] getPlayerOffsets();

    public void func_184232_k(Entity passenger) {
        if (!this.func_184196_w(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        double height = 0.0;
        List passengers = this.func_184188_bt();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vec3d offset = this.getPlayerOffsets()[i];
            front = offset.field_72450_a;
            side = offset.field_72449_c;
            height = offset.field_72448_b;
        }
        Vec3d vec3d = new Vec3d(front, height, side).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
        passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + vec3d.field_72448_b, this.field_70161_v + vec3d.field_72449_c);
        passenger.field_70177_z += this.deltaRotation;
        passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public Entity func_184179_bs() {
        return this.getDriver();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        if (!((Boolean)Config.collideWithEntities.get()).booleanValue() && !(entityIn instanceof EntityVehicleBase)) {
            return null;
        }
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.field_70121_D;
    }

    public void func_174826_a(AxisAlignedBB boundingBox) {
        this.field_70121_D = boundingBox;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    private void tickLerp() {
        if (this.steps > 0 && !this.func_184186_bw()) {
            double x = this.field_70165_t + (this.clientX - this.field_70165_t) / (double)this.steps;
            double y = this.field_70163_u + (this.clientY - this.field_70163_u) / (double)this.steps;
            double z = this.field_70161_v + (this.clientZ - this.field_70161_v) / (double)this.steps;
            double d3 = MathHelper.func_76138_g((double)(this.clientYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.steps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.clientPitch - (double)this.field_70125_A) / (double)this.steps);
            --this.steps;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static final double calculateMotionX(float speed, float rotationYaw) {
        return MathHelper.func_76126_a((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static final double calculateMotionZ(float speed, float rotationYaw) {
        return MathHelper.func_76134_b((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.func_70093_af()) {
            if (player.func_184187_bx() != this && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public abstract boolean doesEnterThirdPerson();

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

