/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBodyWoodBase;
import de.maxhenkel.car.entity.car.parts.PartModel;
import de.maxhenkel.car.entity.model.obj.OBJModel;
import de.maxhenkel.car.entity.model.obj.OBJModelInstance;
import de.maxhenkel.car.entity.model.obj.OBJModelOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PartBumper
extends PartModel {
    public PartBumper(ResourceLocation texture) {
        super(new OBJModel(new ResourceLocation("car", "models/entity/wood_bumper.obj"), texture));
    }

    @Override
    public List<OBJModelInstance> getInstances(EntityGenericCar car) {
        PartBodyWoodBase chassis = car.getPartByClass(PartBodyWoodBase.class);
        if (chassis == null) {
            return super.getInstances(car);
        }
        ArrayList<OBJModelInstance> list = new ArrayList<OBJModelInstance>();
        list.add(new OBJModelInstance(this.model, new OBJModelOptions(chassis.getBumperOffset(), this.rotation)));
        this.onPartAdd(list);
        return list;
    }

    @Override
    public boolean validate(List<Part> parts, List<ITextComponent> messages) {
        if (Part.getAmount(parts, part -> part instanceof PartBodyWoodBase) != 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.no_body_for_bumper", new Object[0]));
            return false;
        }
        return true;
    }
}

