/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartTank;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class PartEngine
extends Part {
    protected float maxSpeed;
    protected float maxReverseSpeed;
    protected float acceleration;
    protected float fuelEfficiency;

    public PartEngine(float maxSpeed, float maxReverseSpeed, float acceleration, float fuelEfficiency) {
        this.maxSpeed = maxSpeed;
        this.maxReverseSpeed = maxReverseSpeed;
        this.acceleration = acceleration;
        this.fuelEfficiency = fuelEfficiency;
    }

    public abstract SoundEvent getStopSound();

    public abstract SoundEvent getFailSound();

    public abstract SoundEvent getCrashSound();

    public abstract SoundEvent getStartSound();

    public abstract SoundEvent getStartingSound();

    public abstract SoundEvent getIdleSound();

    public abstract SoundEvent getHighSound();

    public abstract SoundEvent getHornSound();

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public float getMaxReverseSpeed() {
        return this.maxReverseSpeed;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getFuelEfficiency() {
        return this.fuelEfficiency;
    }

    @Override
    public boolean validate(List<Part> parts, List<ITextComponent> messages) {
        if (PartEngine.getAmount(parts, part -> part instanceof PartTank) > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_tanks", new Object[0]));
        } else if (PartEngine.getAmount(parts, part -> part instanceof PartTank) <= 0) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.no_tank", new Object[0]));
        }
        return super.validate(parts, messages);
    }
}

