/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBody;
import de.maxhenkel.car.entity.car.parts.PartModel;
import de.maxhenkel.car.entity.model.obj.OBJModel;
import de.maxhenkel.car.entity.model.obj.OBJModelInstance;
import de.maxhenkel.car.entity.model.obj.OBJModelOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PartWheelBase
extends PartModel {
    protected float rotationModifier;
    protected float stepHeight;

    public PartWheelBase(OBJModel model, float rotationModifier, float stepHeight) {
        super(model);
        this.rotationModifier = rotationModifier;
        this.stepHeight = stepHeight;
    }

    public float getStepHeight() {
        return this.stepHeight;
    }

    public float getRotationModifier() {
        return this.rotationModifier;
    }

    @Override
    public boolean validate(List<Part> parts, List<ITextComponent> messages) {
        for (Part part : parts) {
            PartBody body;
            if (!(part instanceof PartBody) || (body = (PartBody)part).canFitWheel(this)) continue;
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.wrong_wheel_type", new Object[0]));
            return false;
        }
        return super.validate(parts, messages);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OBJModelInstance> getInstances(EntityGenericCar car) {
        void var5_8;
        ArrayList<OBJModelInstance> list = new ArrayList<OBJModelInstance>();
        Vec3d[] wheelOffsets = new Vec3d[]{};
        for (Part part : car.getModelParts()) {
            if (!(part instanceof PartBody)) continue;
            wheelOffsets = ((PartBody)part).getWheelOffsets();
        }
        ArrayList<PartWheelBase> wheels = new ArrayList<PartWheelBase>();
        for (Part part : car.getModelParts()) {
            if (!(part instanceof PartWheelBase)) continue;
            wheels.add((PartWheelBase)part);
        }
        boolean bl = false;
        while (var5_8 < wheelOffsets.length && var5_8 < wheels.size()) {
            list.add(new OBJModelInstance(((PartWheelBase)wheels.get((int)var5_8)).model, new OBJModelOptions(wheelOffsets[var5_8], null, partialTicks -> GlStateManager.rotatef((float)(-car.getWheelRotation(partialTicks)), (float)1.0f, (float)0.0f, (float)0.0f))));
            ++var5_8;
        }
        return list;
    }
}

