/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.model.obj;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.entity.car.base.EntityCarLicensePlateBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.model.obj.OBJModelInstance;
import de.maxhenkel.car.entity.model.obj.OBJRenderer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class OBJModelRenderer<T extends EntityGenericCar>
extends EntityRenderer<T> {
    protected OBJModelRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public abstract List<OBJModelInstance> getModels(T var1);

    protected ResourceLocation getEntityTexture(T entity) {
        return null;
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        String text;
        List<OBJModelInstance> models = this.getModels(entity);
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw);
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        for (int i = 0; i < models.size(); ++i) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(models.get(i).getModel().getTexture());
            GlStateManager.pushMatrix();
            if (models.get(i).getModel().hasCulling()) {
                GlStateManager.enableCull();
            } else {
                GlStateManager.disableCull();
            }
            GlStateManager.translated((double)models.get((int)i).getOptions().getOffset().field_72450_a, (double)models.get((int)i).getOptions().getOffset().field_72448_b, (double)models.get((int)i).getOptions().getOffset().field_72449_c);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (models.get(i).getOptions().getRotation() != null) {
                models.get(i).getOptions().getRotation().applyGLRotation();
            }
            if (models.get(i).getOptions().getOnRender() != null) {
                models.get(i).getOptions().getOnRender().onRender(partialTicks);
            }
            OBJRenderer.renderObj(models.get(i).getModel().getModel());
            GlStateManager.enableCull();
            GlStateManager.popMatrix();
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        if (entity instanceof EntityCarLicensePlateBase && (text = ((EntityCarLicensePlateBase)((Object)entity)).getLicensePlate()) != null && !text.isEmpty()) {
            GlStateManager.pushMatrix();
            GlStateManager.enableNormalize();
            GlStateManager.disableLighting();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawNumberPlate((EntityGenericCar)((Object)entity), text);
            GlStateManager.enableLighting();
            GlStateManager.disableNormalize();
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    private void drawNumberPlate(EntityGenericCar car, String txt) {
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.translateNumberPlate(car);
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(txt);
        float textScale = 0.01f;
        GlStateManager.translatef((float)(-(textScale * (float)textWidth) / 2.0f), (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)textScale, (float)textScale, (float)textScale);
        Minecraft.func_71410_x().field_71466_p.func_211126_b(TextFormatting.WHITE + txt, 0.0f, 0.0f, 0);
        GlStateManager.popMatrix();
    }

    public abstract void translateNumberPlate(EntityGenericCar var1);

    public void setupRotation(T entity, float yaw) {
        GlStateManager.rotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void setupTranslation(double x, double y, double z) {
        GlStateManager.translated((double)x, (double)y, (double)z);
    }

    public boolean func_188295_H_() {
        return false;
    }
}

