/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.model.obj;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.obj.OBJModel;

public class OBJRenderer {
    public static void renderObj(OBJModel model) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        Collection groups = model.getMatLib().getGroups().values();
        Iterator<OBJModel.Group> iterGroup = groups.iterator();
        OBJRenderer.renderGroups(vertexBuffer, iterGroup);
        tessellator.func_78381_a();
    }

    private static void renderGroups(BufferBuilder vertexbuffer, Iterator<OBJModel.Group> iterGroup) {
        vertexbuffer.func_181668_a(4, DefaultVertexFormats.field_181710_j);
        while (iterGroup.hasNext()) {
            OBJModel.Group g = iterGroup.next();
            LinkedHashSet faces = g.getFaces();
            for (OBJModel.Face f : faces) {
                OBJModel.Vertex[] vertices = f.getVertices();
                float offset = 5.0E-4f;
                Vector3f faceNormal = OBJRenderer.calculateFaceNormal(vertices[0], vertices[1], vertices[2]);
                OBJModel.TextureCoordinate tc0 = vertices[0].getTextureCoordinate();
                OBJModel.TextureCoordinate tc1 = vertices[1].getTextureCoordinate();
                OBJModel.TextureCoordinate tc2 = vertices[2].getTextureCoordinate();
                float averageU = (tc0.u + tc1.u + tc2.u) / 3.0f;
                float averageV = (tc0.v + tc1.v + tc2.v) / 3.0f;
                float offsetU = offset;
                float offsetV = offset;
                Vector4f pos = vertices[0].getPos();
                if (tc0.u > averageU) {
                    offsetU = -offsetU;
                }
                if (tc0.v > averageV) {
                    offsetV = -offsetV;
                }
                vertexbuffer.func_181662_b((double)pos.x, (double)pos.y, (double)pos.z).func_187315_a((double)(tc0.u + offsetU), (double)(1.0f - (tc0.v + offsetV))).func_181663_c(faceNormal.x, faceNormal.y, faceNormal.z).func_181675_d();
                offsetU = offset;
                offsetV = offset;
                pos = vertices[1].getPos();
                if (tc1.u > averageU) {
                    offsetU = -offsetU;
                }
                if (tc1.v > averageV) {
                    offsetV = -offsetV;
                }
                vertexbuffer.func_181662_b((double)pos.x, (double)pos.y, (double)pos.z).func_187315_a((double)(tc1.u + offsetU), (double)(1.0f - (tc1.v + offsetV))).func_181663_c(faceNormal.x, faceNormal.y, faceNormal.z).func_181675_d();
                offsetU = offset;
                offsetV = offset;
                pos = vertices[2].getPos();
                if (tc2.u > averageU) {
                    offsetU = -offsetU;
                }
                if (tc2.v > averageV) {
                    offsetV = -offsetV;
                }
                vertexbuffer.func_181662_b((double)pos.x, (double)pos.y, (double)pos.z).func_187315_a((double)(tc2.u + offsetU), (double)(1.0f - (tc2.v + offsetV))).func_181663_c(faceNormal.x, faceNormal.y, faceNormal.z).func_181675_d();
            }
        }
    }

    private static Vector3f calculateFaceNormal(OBJModel.Vertex v0, OBJModel.Vertex v1, OBJModel.Vertex v2) {
        Vector4f pos0 = v0.getPos();
        Vector4f pos1 = v1.getPos();
        Vector4f pos2 = v2.getPos();
        Vec3d vec1 = new Vec3d((double)(pos1.x - pos0.x), (double)(pos1.y - pos0.y), (double)(pos1.z - pos0.z));
        Vec3d vec2 = new Vec3d((double)(pos2.x - pos0.x), (double)(pos2.y - pos0.y), (double)(pos2.z - pos0.z));
        Vec3d normalVector = vec1.func_72431_c(vec2).func_72432_b();
        return new Vector3f((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }
}

