/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import de.maxhenkel.car.gui.GuiBase;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiBackmixReactor
extends GuiBase<ContainerBackmixReactor> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_backmix_reactor.png");
    private static final int fontColor = 0x404040;
    private IInventory playerInv;
    private TileEntityBackmixReactor tile;

    public GuiBackmixReactor(ContainerBackmixReactor container, PlayerInventory playerInv, ITextComponent name) {
        super(GUI_TEXTURE, container, playerInv, name);
        this.playerInv = playerInv;
        this.tile = container.getBackmixReactor();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (mouseX >= this.field_147003_i + 11 && mouseX <= this.field_147003_i + 16 + 11 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<String>();
            list.add(new TranslationTextComponent("tooltip.energy", new Object[]{this.tile.getStoredEnergy()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 33 && mouseX <= this.field_147003_i + 16 + 33 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.oil", new Object[]{this.tile.getCurrentCanola()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 55 && mouseX <= this.field_147003_i + 16 + 55 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.methanol", new Object[]{this.tile.getCurrentMethanol()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 122 && mouseX <= this.field_147003_i + 16 + 122 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.mix", new Object[]{this.tile.getCurrentMix()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 79 && mouseX <= this.field_147003_i + 24 + 79 && mouseY >= this.field_147009_r + 34 && mouseY <= this.field_147009_r + 17 + 34) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.progress", new Object[]{(int)(this.getProgress() * 100.0f)}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawProgress();
        this.drawEnergy();
        this.drawCanola();
        this.drawMethanol();
        this.drawMix();
    }

    public void drawEnergy() {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawCanola() {
        float perc = this.getCanola();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 33;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMethanol() {
        float perc = this.getMethanol();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 55;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMix() {
        float perc = this.getMix();
        int texX = 224;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress() {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getCanola() {
        return (float)this.tile.getCurrentCanola() / (float)this.tile.maxCanola;
    }

    public float getMethanol() {
        return (float)this.tile.getCurrentMethanol() / (float)this.tile.maxMethanol;
    }

    public float getMix() {
        return (float)this.tile.getCurrentMix() / (float)this.tile.maxMix;
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.getTimeToGenerate();
        return (float)time / (float)this.tile.generatingTime;
    }
}

