/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityFuelStation;
import de.maxhenkel.car.gui.ContainerFuelStationAdmin;
import de.maxhenkel.car.gui.GuiBase;
import de.maxhenkel.car.net.MessageFuelStationAdminAmount;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiFuelStationAdmin
extends GuiBase<ContainerFuelStationAdmin> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_fuelstation_admin.png");
    private TileEntityFuelStation fuelStation;
    private PlayerInventory inventoryPlayer;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected TextFieldWidget textField;

    public GuiFuelStationAdmin(ContainerFuelStationAdmin fuelStation, PlayerInventory playerInventory, ITextComponent title) {
        super(GUI_TEXTURE, fuelStation, playerInventory, title);
        this.fuelStation = fuelStation.getFuelStation();
        this.inventoryPlayer = playerInventory;
        this.field_146999_f = 176;
        this.field_147000_g = 197;
    }

    protected void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.textField = new TextFieldWidget(this.font, this.field_147003_i + 54, this.field_147009_r + 22, 100, 16, new TranslationTextComponent("fuelstation.admin.amount_text_field", new Object[0]).func_150254_d());
        this.textField.func_146205_d(false);
        this.textField.changeFocus(true);
        this.textField.func_146193_g(-1);
        this.textField.func_146204_h(-1);
        this.textField.func_146203_f(20);
        this.textField.func_146180_a(String.valueOf(this.fuelStation.getTradeAmount()));
        this.textField.func_212954_a(this::onTextChanged);
        this.children.add(this.textField);
        this.setFocused((IGuiEventListener)this.textField);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        this.textField.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void onTextChanged(String text) {
        if (this.textField.isFocused() && !text.isEmpty()) {
            try {
                int i = Integer.parseInt(text);
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFuelStationAdminAmount(this.fuelStation.func_174877_v(), i));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removed() {
        super.removed();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void resize(Minecraft mc, int x, int y) {
        String text = this.textField.func_146179_b();
        this.init(mc, x, y);
        this.textField.func_146180_a(text);
    }

    public boolean keyPressed(int key, int a, int b) {
        if (key == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return !this.textField.keyPressed(key, a, b) && !this.textField.func_212955_f() ? super.keyPressed(key, a, b) : true;
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.drawCenteredString(this.font, new TranslationTextComponent("gui.fuelstation", new Object[0]).func_150254_d(), this.field_146999_f / 2, 5, TITLE_COLOR);
        this.font.func_211126_b(this.inventoryPlayer.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 93), FONT_COLOR);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

