/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityTools {
    @Nullable
    public static EntityGenericCar getCarByUUID(PlayerEntity player, UUID uuid) {
        double distance = 10.0;
        return player.field_70170_p.func_175647_a(EntityGenericCar.class, new AxisAlignedBB(player.field_70165_t - distance, player.field_70163_u - distance, player.field_70161_v - distance, player.field_70165_t + distance, player.field_70163_u + distance, player.field_70161_v + distance), entity -> entity.func_110124_au().equals(uuid)).stream().findAny().orElse(null);
    }

    public static void drawCarOnScreen(int posX, int posY, int scale, float rotation, EntityCarBase ent) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)posX, (float)posY, (float)50.0f);
        GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }

    public static interface Renderer {
        public void render(float var1);

        public void tick();
    }

    public static class SimulatedTicker {
        private static final long ONE_TICK = 50000000L;
        private long lastTick;

        public void render(Renderer renderer) {
            long currentNanos = System.nanoTime();
            if (currentNanos - this.lastTick >= 50000000L) {
                renderer.tick();
                this.lastTick = currentNanos;
            }
            renderer.render((float)(currentNanos - this.lastTick) / 5.0E7f);
        }
    }

    public static class SimulatedCarRenderer {
        private float rotation;
        private float rotationPerTick;
        private SimulatedTicker ticker;

        public SimulatedCarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.ticker = new SimulatedTicker();
        }

        public SimulatedCarRenderer() {
            this(3.6f);
        }

        public void render(final EntityCarBase car, final int posX, final int posY, final int scale) {
            this.ticker.render(new Renderer(){

                @Override
                public void render(float partialTicks) {
                    EntityTools.drawCarOnScreen(posX, posY, scale, rotation + rotationPerTick * partialTicks, car);
                }

                @Override
                public void tick() {
                    rotation = rotation + rotationPerTick;
                    if (rotation >= 360.0f) {
                        rotation = 0.0f;
                    }
                }
            });
        }
    }

    public static class CarRenderer {
        private float rotation;
        private float rotationPerTick;
        private Minecraft minecraft;

        public CarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.minecraft = Minecraft.func_71410_x();
        }

        public CarRenderer() {
            this(3.6f);
        }

        public void tick() {
            this.rotation += this.rotationPerTick;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
        }

        public void render(EntityCarBase car, int posX, int posY, int scale) {
            EntityTools.drawCarOnScreen(posX, posY, scale, this.rotation + this.rotationPerTick * this.minecraft.func_184121_ak(), car);
        }
    }
}

