/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import de.maxhenkel.car.blocks.BlockTank;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidUtils {
    public static boolean isFluidHandler(IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        return te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()).isPresent();
    }

    public static IFluidHandler getFluidHandler(IWorldReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te == null) {
            return null;
        }
        return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()).orElse(null);
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer, Fluid filter) {
        int fillableAmount;
        FluidStack drainable = fluidSource.drain(new FluidStack(filter, maxAmount), IFluidHandler.FluidAction.SIMULATE);
        if (drainable != null && drainable.getAmount() > 0 && (fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(new FluidStack(filter, fillableAmount), IFluidHandler.FluidAction.EXECUTE);
                if (drained != null) {
                    drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                    return drained;
                }
            } else {
                drainable.setAmount(fillableAmount);
                return drainable;
            }
        }
        return null;
    }

    public static boolean isEmpty(FluidStack stack) {
        return stack.isEmpty() || stack == FluidStack.EMPTY || stack.getFluid() == Fluids.field_204541_a;
    }

    public static boolean tryFluidInteraction(PlayerEntity player, Hand hand, World world, BlockPos pos) {
        boolean success1;
        boolean success;
        ItemStack stack = player.func_184586_b(hand);
        FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY);
        if (!FluidUtils.isEmpty(fluidStack) && (success = BlockTank.handleEmpty(stack, world, pos, player, hand))) {
            return true;
        }
        IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
        return handler != null && (success1 = BlockTank.handleFill(stack, world, pos, player, hand));
    }
}

