/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.block;

import cityofskytcd.chineseworkshop.TextureModule;
import cityofskytcd.chineseworkshop.block.Direction2;
import cityofskytcd.chineseworkshop.block.Direction2Block;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RoofTileRidgeBlock
extends Direction2Block {
    public final VoxelShape SHAPE;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.func_177709_a((String)"variant", Variant.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RoofTileRidgeBlock(Block.Properties builder, VoxelShape shape, boolean retexture) {
        super(builder, retexture);
        this.SHAPE = shape;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(VARIANT, (Comparable)((Object)Variant.I))).func_206870_a((IProperty)FACING, (Comparable)((Object)Direction2.SOUTH_NORTH)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isTextureable()) {
            TextureModule.addTooltip(stack, tooltip, "frame");
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.SHAPE;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState state = (BlockState)super.func_196258_a(context).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)this.getVariantProperty(state, (IBlockReader)context.func_195991_k(), blockpos)));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)this.getVariantProperty(state, (IBlockReader)worldIn, currentPos)));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private Variant getVariantProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        int i;
        int connection = 0;
        boolean[] connect = new boolean[4];
        for (i = 0; i < 4; ++i) {
            Direction facing = Direction.func_176731_b((int)i);
            if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) continue;
            ++connection;
            connect[i] = true;
        }
        if (connection == 4) {
            return Variant.X;
        }
        if (connection == 3) {
            for (i = 0; i < 4; ++i) {
                if (connect[i]) continue;
                return Variant.values()[Variant.T.ordinal() + i];
            }
        } else {
            if (connection == 2) {
                if (connect[0] && connect[2] || connect[1] && connect[3]) {
                    return connect[0] ? Variant.I : Variant.I_90;
                }
                Variant variant = Variant.L_270;
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (!connect[i2] || !connect[i2 + 1]) continue;
                    variant = Variant.values()[Variant.L.ordinal() + i2];
                    break;
                }
                return variant;
            }
            if (connection == 1) {
                return connect[0] || connect[2] ? Variant.I : Variant.I_90;
            }
        }
        return state.func_177229_b((IProperty)FACING) == Direction2.EAST_WEST ? Variant.I : Variant.I_90;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, VARIANT, WATERLOGGED});
    }

    public static enum Variant implements IStringSerializable
    {
        I,
        I_90,
        L,
        L_90,
        L_180,
        L_270,
        T,
        T_90,
        T_180,
        T_270,
        X;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

